/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.objects.AllyMob;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class AllyManager {
    private static AllyManager instance = new AllyManager();
    private List<AllyMob> allyMobs = new ArrayList<AllyMob>();
    private Map<UUID, List<AllyMob>> allyOwners = new HashMap<UUID, List<AllyMob>>();
    private Map<AllyMob.AllyType, String> allyTypeNameCache = new HashMap<AllyMob.AllyType, String>();

    public void load() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        String allyTypePath = "Settings.EnchantmentOptions.Ally-Mobs.";
        for (AllyMob.AllyType type : AllyMob.AllyType.values()) {
            this.allyTypeNameCache.put(type, Methods.color(config.getString(allyTypePath + type.getConfigName(), type.getDefaultName())));
        }
    }

    public List<AllyMob> getAllyMobs() {
        return this.allyMobs;
    }

    public void addAllyMob(AllyMob allyMob) {
        if (allyMob != null) {
            this.allyMobs.add(allyMob);
            UUID owner = allyMob.getOwner().getUniqueId();
            if (this.allyOwners.containsKey(owner)) {
                this.allyOwners.get(owner).add(allyMob);
            } else {
                ArrayList<AllyMob> allies = new ArrayList<AllyMob>();
                allies.add(allyMob);
                this.allyOwners.put(owner, allies);
            }
        }
    }

    public void removeAllyMob(AllyMob allyMob) {
        if (allyMob != null) {
            this.allyMobs.remove(allyMob);
            UUID owner = allyMob.getOwner().getUniqueId();
            if (this.allyOwners.containsKey(owner)) {
                this.allyOwners.get(owner).add(allyMob);
                if (this.allyOwners.get(owner).isEmpty()) {
                    this.allyOwners.remove(owner);
                }
            }
        }
    }

    public void forceRemoveAllies() {
        this.allyMobs.forEach(ally -> ally.getAlly().remove());
        this.allyMobs.clear();
        this.allyOwners.clear();
    }

    public void forceRemoveAllies(Player owner) {
        for (AllyMob ally : (List)this.allyOwners.getOrDefault(owner.getUniqueId(), new ArrayList())) {
            ally.getAlly().remove();
            this.allyMobs.remove(ally);
        }
        this.allyOwners.remove(owner.getUniqueId());
    }

    public void setEnemy(Player owner, LivingEntity enemy) {
        ((List)this.allyOwners.getOrDefault(owner.getUniqueId(), new ArrayList())).forEach(ally -> ally.attackEnemy(enemy));
    }

    public Map<AllyMob.AllyType, String> getAllyTypeNameCache() {
        return this.allyTypeNameCache;
    }

    public boolean isAlly(Player player, LivingEntity livingEntity) {
        if (this.isAllyMob(livingEntity)) {
            return this.isAlly(player, this.getAllyMob(livingEntity));
        }
        return false;
    }

    public boolean isAlly(Player player, AllyMob ally) {
        return ally.getOwner().getUniqueId() == player.getUniqueId();
    }

    public boolean isAllyMob(LivingEntity livingEntity) {
        for (AllyMob ally : this.allyMobs) {
            if (ally.getAlly().getUniqueId() != livingEntity.getUniqueId()) continue;
            return true;
        }
        return false;
    }

    public AllyMob getAllyMob(LivingEntity livingEntity) {
        for (AllyMob ally : this.allyMobs) {
            if (ally.getAlly().getUniqueId() != livingEntity.getUniqueId()) continue;
            return ally;
        }
        return null;
    }

    public static AllyManager getInstance() {
        return instance;
    }
}

