/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.enums;

import java.util.HashMap;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public enum ShopOption {
    GKITZ("GKitz", "GKitz", "Name", "Lore", false),
    BLACKSMITH("BlackSmith", "BlackSmith", "Name", "Lore", false),
    TINKER("Tinker", "Tinker", "Name", "Lore", false),
    INFO("Info", "Info", "Name", "Lore", false),
    PROTECTION_CRYSTAL("ProtectionCrystal", "ProtectionCrystal", "GUIName", "GUILore", true),
    SUCCESS_DUST("SuccessDust", "Dust.SuccessDust", "GUIName", "GUILore", true),
    DESTROY_DUST("DestroyDust", "Dust.DestroyDust", "GUIName", "GUILore", true),
    SCRAMBLER("Scrambler", "Scrambler", "GUIName", "GUILore", true),
    BLACK_SCROLL("BlackScroll", "BlackScroll", "GUIName", "Lore", true),
    WHITE_SCROLL("WhiteScroll", "WhiteScroll", "GUIName", "Lore", true),
    TRANSMOG_SCROLL("TransmogScroll", "TransmogScroll", "GUIName", "Lore", true);

    private static HashMap<ShopOption, Option> shopOptions;
    private String optionPath;
    private String path;
    private String namePath;
    private String lorePath;
    private Option option;
    private boolean buyable;

    private ShopOption(String optionPath, String path, String namePath, String lorePath, boolean buyable) {
        this.optionPath = optionPath;
        this.path = path;
        this.namePath = namePath;
        this.lorePath = lorePath;
        this.buyable = buyable;
    }

    public static void loadShopOptions() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        shopOptions.clear();
        for (ShopOption shopOption : ShopOption.values()) {
            String itemPath = "Settings." + shopOption.getPath() + ".";
            String costPath = "Settings.Costs." + shopOption.getOptionPath() + ".";
            try {
                shopOptions.put(shopOption, new Option(new ItemBuilder().setName(config.getString(itemPath + shopOption.getNamePath())).setLore(config.getStringList(itemPath + shopOption.getLorePath())).setMaterial(config.getString(itemPath + "Item")).setGlowing(config.getBoolean(itemPath + "Glowing")), config.getInt(itemPath + "Slot", 1) - 1, config.getBoolean(itemPath + "InGUI"), config.getInt(costPath + "Cost", 100), Currency.getCurrency(config.getString(costPath + "Currency", "Vault"))));
            }
            catch (Exception e) {
                System.out.println("The option " + shopOption.getOptionPath() + " has failed to load.");
                e.printStackTrace();
            }
        }
    }

    public ItemStack getItem() {
        return this.getItemBuilder().build();
    }

    public ItemBuilder getItemBuilder() {
        return shopOptions.get((Object)this).getItemBuilder();
    }

    public int getSlot() {
        return shopOptions.get((Object)this).getSlot();
    }

    public boolean isInGUI() {
        return shopOptions.get((Object)this).isInGUI();
    }

    public int getCost() {
        return shopOptions.get((Object)this).getCost();
    }

    public Currency getCurrency() {
        return shopOptions.get((Object)this).getCurrency();
    }

    private String getOptionPath() {
        return this.optionPath;
    }

    private String getPath() {
        return this.path;
    }

    private String getNamePath() {
        return this.namePath;
    }

    private String getLorePath() {
        return this.lorePath;
    }

    public boolean isBuyable() {
        return this.buyable;
    }

    static {
        shopOptions = new HashMap();
    }

    private static class Option {
        private ItemBuilder itemBuilder;
        private int slot;
        private boolean inGUI;
        private int cost;
        private Currency currency;

        public Option(ItemBuilder itemBuilder, int slot, boolean inGUI, int cost, Currency currency) {
            this.itemBuilder = itemBuilder;
            this.slot = slot;
            this.inGUI = inGUI;
            this.cost = cost;
            this.currency = currency;
        }

        public ItemBuilder getItemBuilder() {
            return this.itemBuilder;
        }

        public int getSlot() {
            return this.slot;
        }

        public boolean isInGUI() {
            return this.inGUI;
        }

        public int getCost() {
            return this.cost;
        }

        public Currency getCurrency() {
            return this.currency;
        }
    }
}

