/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.enums;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public enum Scrolls {
    BLACK_SCROLL("Black-Scroll", "BlackScroll", Arrays.asList("b", "black", "blackscroll")),
    WHITE_SCROLL("White-Scroll", "WhiteScroll", Arrays.asList("w", "white", "whitescroll")),
    TRANSMOG_SCROLL("Transmog-Scroll", "TransmogScroll", Arrays.asList("t", "transmog", "transmogscroll"));

    private static HashMap<Scrolls, ItemBuilder> itemBuilderScrolls;
    private String name;
    private String configName;
    private List<String> knownNames;

    private Scrolls(String name, String configName, List<String> knowNames) {
        this.name = name;
        this.knownNames = knowNames;
        this.configName = configName;
    }

    public static void loadScrolls() {
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        itemBuilderScrolls.clear();
        for (Scrolls scroll : Scrolls.values()) {
            String path = "Settings." + scroll.getConfigName() + ".";
            itemBuilderScrolls.put(scroll, new ItemBuilder().setName(config.getString(path + "Name")).setLore(config.getStringList(path + "Item-Lore")).setMaterial(config.getString(path + "Item")).setGlowing(config.getBoolean(path + "Glowing")));
        }
    }

    public static Scrolls getFromName(String nameString) {
        for (Scrolls scroll : Scrolls.values()) {
            if (!scroll.getKnownNames().contains(nameString.toLowerCase())) continue;
            return scroll;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getKnownNames() {
        return this.knownNames;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ItemStack getScroll() {
        return itemBuilderScrolls.get((Object)this).build();
    }

    public ItemStack getScroll(int amount) {
        return itemBuilderScrolls.get((Object)this).setAmount(amount).build();
    }

    static {
        itemBuilderScrolls = new HashMap();
    }
}

