/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api.currencyapi;

import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.currencyapi.VaultSupport;
import me.badbones69.crazyenchantments.api.enums.ShopOption;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.LostBook;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class CurrencyAPI {
    public static int getCurrency(Player player, Currency currency) {
        try {
            switch (currency) {
                case VAULT: {
                    return (int)VaultSupport.getVault().getBalance((OfflinePlayer)player);
                }
                case XP_LEVEL: {
                    return player.getLevel();
                }
                case XP_TOTAL: {
                    return CurrencyAPI.getTotalExperience(player);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
        return 0;
    }

    public static void takeCurrency(Player player, Category category) {
        CurrencyAPI.takeCurrency(player, category.getCurrency(), category.getCost());
    }

    public static void takeCurrency(Player player, LostBook lostBook) {
        CurrencyAPI.takeCurrency(player, lostBook.getCurrency(), lostBook.getCost());
    }

    public static void takeCurrency(Player player, ShopOption option) {
        CurrencyAPI.takeCurrency(player, option.getCurrency(), option.getCost());
    }

    public static void takeCurrency(Player player, Currency currency, int amount) {
        try {
            switch (currency) {
                case VAULT: {
                    VaultSupport.getVault().withdrawPlayer((OfflinePlayer)player, (double)amount);
                    break;
                }
                case XP_LEVEL: {
                    player.setLevel(player.getLevel() - amount);
                    break;
                }
                case XP_TOTAL: {
                    CurrencyAPI.takeTotalExperience(player, amount);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    public static void giveCurrency(Player player, Currency currency, int amount) {
        try {
            switch (currency) {
                case VAULT: {
                    VaultSupport.getVault().depositPlayer((OfflinePlayer)player, (double)amount);
                    break;
                }
                case XP_LEVEL: {
                    player.setLevel(player.getLevel() + amount);
                    break;
                }
                case XP_TOTAL: {
                    CurrencyAPI.takeTotalExperience(player, -amount);
                }
            }
        }
        catch (Exception | NoClassDefFoundError throwable) {
            // empty catch block
        }
    }

    public static boolean canBuy(Player player, Category category) {
        return CurrencyAPI.canBuy(player, category.getCurrency(), category.getCost());
    }

    public static boolean canBuy(Player player, LostBook lostBook) {
        return CurrencyAPI.canBuy(player, lostBook.getCurrency(), lostBook.getCost());
    }

    public static boolean canBuy(Player player, ShopOption option) {
        return CurrencyAPI.canBuy(player, option.getCurrency(), option.getCost());
    }

    public static boolean canBuy(Player player, Currency currency, int cost) {
        return CurrencyAPI.getCurrency(player, currency) >= cost;
    }

    private static void takeTotalExperience(Player player, int amount) {
        int total;
        player.setTotalExperience(0);
        player.setTotalExperience(total);
        player.setLevel(0);
        player.setExp(0.0f);
        for (total = CurrencyAPI.getTotalExperience(player) - amount; total > player.getExpToLevel(); total -= player.getExpToLevel()) {
            player.setLevel(player.getLevel() + 1);
        }
        float xp = (float)total / (float)player.getExpToLevel();
        player.setExp(xp);
    }

    private static int getTotalExperience(Player player) {
        int level = player.getLevel();
        if (level >= 0 && level <= 15) {
            int experience = (int)Math.ceil(Math.pow(level, 2.0) + (double)(6 * level));
            int requiredExperience = 2 * level + 7;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
            return experience;
        }
        if (level > 15 && level <= 30) {
            int experience = (int)Math.ceil(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
            int requiredExperience = 5 * level - 38;
            double currentExp = Double.parseDouble(Float.toString(player.getExp()));
            experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
            return experience;
        }
        int experience = (int)Math.ceil(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        int requiredExperience = 9 * level - 158;
        double currentExp = Double.parseDouble(Float.toString(player.getExp()));
        experience = (int)((double)experience + Math.ceil(currentExp * (double)requiredExperience));
        return experience;
    }

    public static void loadCurrency() {
        VaultSupport.loadVault();
    }
}

