/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.badbones69.crazyenchantments.multisupport.Version;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class FileManager {
    private static FileManager instance = new FileManager();
    private Plugin plugin;
    private String prefix = "";
    private boolean log = false;
    private Map<Files, File> files = new HashMap<Files, File>();
    private List<String> homeFolders = new ArrayList<String>();
    private List<CustomFile> customFiles = new ArrayList<CustomFile>();
    private Map<String, String> jarHomeFolders = new HashMap<String, String>();
    private Map<String, String> autoGenerateFiles = new HashMap<String, String>();
    private Map<Files, FileConfiguration> configurations = new HashMap<Files, FileConfiguration>();

    public static FileManager getInstance() {
        return instance;
    }

    public FileManager setup(Plugin plugin) {
        this.prefix = "[" + plugin.getName() + "] ";
        this.plugin = plugin;
        if (!plugin.getDataFolder().exists()) {
            plugin.getDataFolder().mkdirs();
        }
        this.files.clear();
        this.customFiles.clear();
        this.configurations.clear();
        for (Files file : Files.values()) {
            String[] newFile = new File(plugin.getDataFolder(), file.getFileLocation());
            if (this.log) {
                System.out.println(this.prefix + "Loading the " + file.getFileName());
            }
            if (!newFile.exists()) {
                try {
                    File serverFile = new File(plugin.getDataFolder(), "/" + file.getFileLocation());
                    InputStream jarFile = this.getClass().getResourceAsStream("/" + file.getFileJar());
                    this.copyFile(jarFile, serverFile);
                }
                catch (Exception e) {
                    if (this.log) {
                        System.out.println(this.prefix + "Failed to load file: " + file.getFileName());
                    }
                    e.printStackTrace();
                    continue;
                }
            }
            this.files.put(file, (File)newFile);
            this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)newFile));
            if (!this.log) continue;
            System.out.println(this.prefix + "Successfully loaded " + file.getFileName());
        }
        if (!this.homeFolders.isEmpty()) {
            if (this.log) {
                System.out.println(this.prefix + "Loading custom files.");
            }
            for (String homeFolder : this.homeFolders) {
                File homeFile = new File(plugin.getDataFolder(), "/" + homeFolder);
                if (homeFile.exists()) {
                    String[] list = homeFile.list();
                    if (list == null) continue;
                    for (String name : list) {
                        CustomFile file;
                        if (!name.endsWith(".yml") || !(file = new CustomFile(name, homeFolder, plugin)).exists()) continue;
                        this.customFiles.add(file);
                        if (!this.log) continue;
                        System.out.println(this.prefix + "Loaded new custom file: " + homeFolder + "/" + name + ".");
                    }
                    continue;
                }
                homeFile.mkdir();
                if (this.log) {
                    System.out.println(this.prefix + "The folder " + homeFolder + "/ was not found so it was created.");
                }
                for (Map.Entry<String, String> file : this.autoGenerateFiles.entrySet()) {
                    if (!file.getValue().equalsIgnoreCase(homeFolder)) continue;
                    homeFolder = file.getValue();
                    try {
                        File serverFile = new File(plugin.getDataFolder(), homeFolder + "/" + file.getKey());
                        InputStream jarFile = this.getClass().getResourceAsStream(this.jarHomeFolders.getOrDefault(file.getKey(), homeFolder) + "/" + file.getKey());
                        this.copyFile(jarFile, serverFile);
                        if (file.getKey().toLowerCase().endsWith(".yml")) {
                            this.customFiles.add(new CustomFile(file.getKey(), homeFolder, plugin));
                        }
                        if (!this.log) continue;
                        System.out.println(this.prefix + "Created new default file: " + homeFolder + "/" + file.getKey() + ".");
                    }
                    catch (Exception e) {
                        if (this.log) {
                            System.out.println(this.prefix + "Failed to create new default file: " + homeFolder + "/" + file.getKey() + "!");
                        }
                        e.printStackTrace();
                    }
                }
            }
            if (this.log) {
                System.out.println(this.prefix + "Finished loading custom files.");
            }
        }
        return this;
    }

    public FileManager logInfo(boolean log) {
        this.log = log;
        return this;
    }

    public boolean isLogging() {
        return this.log;
    }

    public FileManager registerCustomFilesFolder(String homeFolder) {
        this.homeFolders.add(homeFolder);
        return this;
    }

    public FileManager unregisterCustomFilesFolder(String homeFolder) {
        this.homeFolders.remove(homeFolder);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String fileName, String homeFolder) {
        this.autoGenerateFiles.put(fileName, homeFolder);
        return this;
    }

    public FileManager registerDefaultGenerateFiles(String fileName, String homeFolder, String jarHomeFolder) {
        this.autoGenerateFiles.put(fileName, homeFolder);
        this.jarHomeFolders.put(fileName, jarHomeFolder);
        return this;
    }

    public FileManager unregisterDefaultGenerateFiles(String fileName) {
        this.autoGenerateFiles.remove(fileName);
        this.jarHomeFolders.remove(fileName);
        return this;
    }

    public FileConfiguration getFile(Files file) {
        return this.configurations.get((Object)file);
    }

    public CustomFile getFile(String name) {
        for (CustomFile file : this.customFiles) {
            if (!file.getName().toLowerCase().equalsIgnoreCase(name.toLowerCase())) continue;
            return file;
        }
        return null;
    }

    public void saveFile(Files file) {
        try {
            this.configurations.get((Object)file).save(this.files.get((Object)file));
        }
        catch (IOException e) {
            System.out.println(this.prefix + "Could not save " + file.getFileName() + "!");
            e.printStackTrace();
        }
    }

    public void saveFile(String name) {
        CustomFile file = this.getFile(name);
        if (file != null) {
            try {
                file.getFile().save(new File(this.plugin.getDataFolder(), file.getHomeFolder() + "/" + file.getFileName()));
                if (this.log) {
                    System.out.println(this.prefix + "Successfully saved the " + file.getFileName() + ".");
                }
            }
            catch (Exception e) {
                System.out.println(this.prefix + "Could not save " + file.getFileName() + "!");
                e.printStackTrace();
            }
        } else if (this.log) {
            System.out.println(this.prefix + "The file " + name + ".yml could not be found!");
        }
    }

    public boolean saveFile(CustomFile file) {
        return file.saveFile();
    }

    public void reloadFile(Files file) {
        this.configurations.put(file, (FileConfiguration)YamlConfiguration.loadConfiguration((File)this.files.get((Object)file)));
    }

    public void reloadFile(String name) {
        CustomFile file = this.getFile(name);
        if (file != null) {
            try {
                file.file = (FileConfiguration)YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + file.getHomeFolder() + "/" + file.getFileName()));
                if (this.log) {
                    System.out.println(this.prefix + "Successfully reload the " + file.getFileName() + ".");
                }
            }
            catch (Exception e) {
                System.out.println(this.prefix + "Could not reload the " + file.getFileName() + "!");
                e.printStackTrace();
            }
        } else if (this.log) {
            System.out.println(this.prefix + "The file " + name + ".yml could not be found!");
        }
    }

    public boolean reloadFile(CustomFile file) {
        return file.reloadFile();
    }

    private void copyFile(InputStream in, File out) throws Exception {
        try (InputStream fis = in;
             FileOutputStream fos = new FileOutputStream(out);){
            int i;
            byte[] buf = new byte[1024];
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
        }
    }

    public class CustomFile {
        private String name;
        private Plugin plugin;
        private String fileName;
        private String homeFolder;
        private FileConfiguration file;

        public CustomFile(String name, String homeFolder, Plugin plugin) {
            this.name = name.replace(".yml", "");
            this.plugin = plugin;
            this.fileName = name;
            this.homeFolder = homeFolder;
            if (new File(plugin.getDataFolder(), "/" + homeFolder).exists()) {
                this.file = new File(plugin.getDataFolder(), "/" + homeFolder + "/" + name).exists() ? YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "/" + homeFolder + "/" + name)) : null;
            } else {
                new File(plugin.getDataFolder(), "/" + homeFolder).mkdir();
                if (FileManager.this.log) {
                    System.out.println(FileManager.this.prefix + "The folder " + homeFolder + "/ was not found so it was created.");
                }
                this.file = null;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getHomeFolder() {
            return this.homeFolder;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public FileConfiguration getFile() {
            return this.file;
        }

        public boolean exists() {
            return this.file != null;
        }

        public boolean saveFile() {
            if (this.file != null) {
                try {
                    this.file.save(new File(this.plugin.getDataFolder(), this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log) {
                        System.out.println(FileManager.this.prefix + "Successfuly saved the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception e) {
                    System.out.println(FileManager.this.prefix + "Could not save " + this.fileName + "!");
                    e.printStackTrace();
                    return false;
                }
            }
            if (FileManager.this.log) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that could not be found!");
            }
            return false;
        }

        public boolean reloadFile() {
            if (this.file != null) {
                try {
                    this.file = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), "/" + this.homeFolder + "/" + this.fileName));
                    if (FileManager.this.log) {
                        System.out.println(FileManager.this.prefix + "Successfuly reload the " + this.fileName + ".");
                    }
                    return true;
                }
                catch (Exception e) {
                    System.out.println(FileManager.this.prefix + "Could not reload the " + this.fileName + "!");
                    e.printStackTrace();
                }
            } else if (FileManager.this.log) {
                System.out.println(FileManager.this.prefix + "There was a null custom file that was not found!");
            }
            return false;
        }
    }

    public static enum Files {
        CONFIG("config.yml", "config.yml", "config1.13-Up.yml", "config1.12.2-Down.yml"),
        BLOCKLIST("BlockList.yml", "BlockList.yml", "BlockList1.13-Up.yml", "BlockList1.12.2-Down.yml"),
        DATA("Data.yml", "Data.yml"),
        ENCHANTMENTS("Enchantments.yml", "Enchantments.yml"),
        GKITZ("GKitz.yml", "GKitz.yml", "GKitz1.13-Up.yml", "GKitz1.12.2-Down.yml"),
        MESSAGES("Messages.yml", "Messages.yml"),
        ENCHANTMENT_TYPES("Enchantment-Types.yml", "Enchantment-Types.yml", "Enchantment-Types1.13-Up.yml", "Enchantment-Types1.12.2-Down.yml"),
        SIGNS("Signs.yml", "Signs.yml"),
        TINKER("Tinker.yml", "Tinker.yml", "Tinker1.13-Up.yml", "Tinker1.12.2-Down.yml");

        private String fileName;
        private String fileJar;
        private String fileLocation;

        private Files(String fileName, String fileLocation) {
            this(fileName, fileLocation, fileLocation);
        }

        private Files(String fileName, String fileLocation, String fileJar) {
            this.fileName = fileName;
            this.fileLocation = fileLocation;
            this.fileJar = fileJar;
        }

        private Files(String fileName, String fileLocation, String newFileJar, String oldFileJar) {
            this(fileName, fileLocation, Version.isNewer(Version.v1_12_R1) ? newFileJar : oldFileJar);
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileLocation() {
            return this.fileLocation;
        }

        public String getFileJar() {
            return this.fileJar;
        }

        public FileConfiguration getFile() {
            return FileManager.getInstance().getFile(this);
        }

        public void saveFile() {
            FileManager.getInstance().saveFile(this);
        }

        public void relaodFile() {
            FileManager.getInstance().reloadFile(this);
        }
    }
}

