/*
 * Decompiled with CFR 0.152.
 */
package me.badbones69.crazyenchantments.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import me.badbones69.crazyenchantments.Methods;
import me.badbones69.crazyenchantments.api.FileManager;
import me.badbones69.crazyenchantments.api.currencyapi.Currency;
import me.badbones69.crazyenchantments.api.enums.CEnchantments;
import me.badbones69.crazyenchantments.api.enums.Dust;
import me.badbones69.crazyenchantments.api.enums.Scrolls;
import me.badbones69.crazyenchantments.api.enums.ShopOption;
import me.badbones69.crazyenchantments.api.managers.AllyManager;
import me.badbones69.crazyenchantments.api.managers.ArmorEnchantmentManager;
import me.badbones69.crazyenchantments.api.managers.BlackSmithManager;
import me.badbones69.crazyenchantments.api.managers.BowEnchantmentManager;
import me.badbones69.crazyenchantments.api.managers.InfoMenuManager;
import me.badbones69.crazyenchantments.api.managers.ShopManager;
import me.badbones69.crazyenchantments.api.managers.WingsManager;
import me.badbones69.crazyenchantments.api.objects.CEBook;
import me.badbones69.crazyenchantments.api.objects.CEPlayer;
import me.badbones69.crazyenchantments.api.objects.CEnchantment;
import me.badbones69.crazyenchantments.api.objects.Category;
import me.badbones69.crazyenchantments.api.objects.Cooldown;
import me.badbones69.crazyenchantments.api.objects.EnchantmentType;
import me.badbones69.crazyenchantments.api.objects.GKitz;
import me.badbones69.crazyenchantments.api.objects.ItemBuilder;
import me.badbones69.crazyenchantments.api.objects.LostBook;
import me.badbones69.crazyenchantments.controllers.ProtectionCrystal;
import me.badbones69.crazyenchantments.controllers.Scrambler;
import me.badbones69.crazyenchantments.controllers.ScrollControl;
import me.badbones69.crazyenchantments.enchantments.Boots;
import me.badbones69.crazyenchantments.multisupport.NMSSupport;
import me.badbones69.crazyenchantments.multisupport.NMS_v1_12_2_Down;
import me.badbones69.crazyenchantments.multisupport.NMS_v1_13_Up;
import me.badbones69.crazyenchantments.multisupport.Support;
import me.badbones69.crazyenchantments.multisupport.Version;
import me.badbones69.crazyenchantments.multisupport.plotsquared.PlotSquared;
import me.badbones69.crazyenchantments.multisupport.plotsquared.PlotSquaredVersion;
import me.badbones69.crazyenchantments.multisupport.worldguard.WorldGuardVersion;
import me.badbones69.crazyenchantments.multisupport.worldguard.WorldGuard_v6;
import me.badbones69.crazyenchantments.multisupport.worldguard.WorldGuard_v7;
import me.badbones69.crazyenchantments.nbtapi.NBTItem;
import me.badbones69.premiumhooks.plotsquared.PlotSquaredLegacy;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class CrazyEnchantments {
    private static CrazyEnchantments instance = new CrazyEnchantments();
    private Plugin plugin;
    private int rageMaxLevel;
    private boolean gkitzToggle;
    private boolean useUnsafeEnchantments;
    private boolean useNewSounds = Version.isNewer(Version.v1_8_R3);
    private boolean useHealthAttributes = Version.isNewer(Version.v1_8_R3);
    private boolean useNewMaterial = Version.isNewer(Version.v1_12_R1);
    private boolean breakRageOnDamage;
    private boolean enchantStackedItems;
    private boolean maxEnchantmentCheck;
    private boolean checkVanillaLimit;
    private ItemBuilder enchantmentBook;
    private NMSSupport nmsSupport;
    private Random random = new Random();
    private String whiteScrollProtectionName;
    private BlackSmithManager blackSmithManager;
    private InfoMenuManager infoMenuManager;
    private ShopManager shopManager;
    private WingsManager wingsManager;
    private BowEnchantmentManager bowManager;
    private ArmorEnchantmentManager armorManager;
    private AllyManager allyManager;
    private WorldGuardVersion worldGuardVersion;
    private PlotSquaredVersion plotSquaredVersion;
    private List<Category> categories = new ArrayList<Category>();
    private List<GKitz> gkitz = new ArrayList<GKitz>();
    private List<CEPlayer> players = new ArrayList<CEPlayer>();
    private List<Material> blockList = new ArrayList<Material>();
    private List<CEnchantment> registeredEnchantments = new ArrayList<CEnchantment>();
    private List<Event> ignoredEvents = new ArrayList<Event>();
    private List<UUID> ignoredUUIDs = new ArrayList<UUID>();

    public static CrazyEnchantments getInstance() {
        return instance;
    }

    public void load() {
        this.blockList.clear();
        this.gkitz.clear();
        this.registeredEnchantments.clear();
        this.categories.clear();
        Support.SupportedPlugins.updatePluginStates();
        this.plugin = Bukkit.getPluginManager().getPlugin("CrazyEnchantments");
        this.blackSmithManager = BlackSmithManager.getInstance();
        this.blackSmithManager.load();
        this.infoMenuManager = InfoMenuManager.getInstance();
        this.infoMenuManager.load();
        CEnchantments.invalidateCachedEnchants();
        this.nmsSupport = this.useNewMaterial ? new NMS_v1_13_Up() : new NMS_v1_12_2_Down();
        FileConfiguration config = FileManager.Files.CONFIG.getFile();
        FileConfiguration gkit = FileManager.Files.GKITZ.getFile();
        FileConfiguration enchants = FileManager.Files.ENCHANTMENTS.getFile();
        for (String id : FileManager.Files.BLOCKLIST.getFile().getStringList("Block-List")) {
            try {
                this.blockList.add(new ItemBuilder().setMaterial(id).getMaterial());
            }
            catch (Exception exception) {}
        }
        this.whiteScrollProtectionName = Methods.color(config.getString("Settings.WhiteScroll.ProtectedName"));
        this.enchantmentBook = new ItemBuilder().setMaterial(config.getString("Settings.Enchantment-Book-Item"));
        this.useUnsafeEnchantments = config.getBoolean("Settings.EnchantmentOptions.UnSafe-Enchantments");
        this.maxEnchantmentCheck = config.getBoolean("Settings.EnchantmentOptions.MaxAmountOfEnchantmentsToggle");
        this.checkVanillaLimit = config.getBoolean("Settings.EnchantmentOptions.IncludeVanillaEnchantments");
        this.gkitzToggle = !config.contains("Settings.GKitz.Enabled") || config.getBoolean("Settings.GKitz.Enabled");
        this.rageMaxLevel = config.contains("Settings.EnchantmentOptions.MaxRageLevel") ? config.getInt("Settings.EnchantmentOptions.MaxRageLevel") : 4;
        this.breakRageOnDamage = !config.contains("Settings.EnchantmentOptions.Break-Rage-On-Damage") || config.getBoolean("Settings.EnchantmentOptions.Break-Rage-On-Damage");
        this.enchantStackedItems = config.contains("Settings.EnchantmentOptions.Enchant-Stacked-Items") && config.getBoolean("Settings.EnchantmentOptions.Enchant-Stacked-Items");
        for (String category : config.getConfigurationSection("Categories").getKeys(false)) {
            String path = "Categories." + category;
            LostBook lostBook = new LostBook(config.getInt(path + ".LostBook.Slot"), config.getBoolean(path + ".LostBook.InGUI"), new ItemBuilder().setMaterial(config.getString(path + ".LostBook.Item")).setName(config.getString(path + ".LostBook.Name")).setLore(config.getStringList(path + ".LostBook.Lore")).setGlowing(config.getBoolean(path + ".LostBook.Glowing")), config.getInt(path + ".LostBook.Cost"), Currency.getCurrency(config.getString(path + ".LostBook.Currency")), config.getBoolean(path + ".LostBook.FireworkToggle"), this.getColors(config.getString(path + ".LostBook.FireworkColors")), config.getBoolean(path + ".LostBook.Sound-Toggle"), config.getString(path + ".LostBook.Sound"));
            this.categories.add(new Category(category, config.getInt(path + ".Slot"), config.getBoolean(path + ".InGUI"), new ItemBuilder().setMaterial(config.getString(path + ".Item")).setName(config.getString(path + ".Name")).setLore(config.getStringList(path + ".Lore")).setGlowing(config.getBoolean(path + ".Glowing")), config.getInt(path + ".Cost"), Currency.getCurrency(config.getString(path + ".Currency")), config.getInt(path + ".Rarity"), lostBook, config.getInt(path + ".EnchOptions.SuccessPercent.Max"), config.getInt(path + ".EnchOptions.SuccessPercent.Min"), config.getInt(path + ".EnchOptions.DestroyPercent.Max"), config.getInt(path + ".EnchOptions.DestroyPercent.Min"), config.getBoolean(path + ".EnchOptions.MaxLvlToggle"), config.getInt(path + ".EnchOptions.LvlRange.Max"), config.getInt(path + ".EnchOptions.LvlRange.Min")));
        }
        for (CEnchantments cEnchantment : CEnchantments.values()) {
            String name = cEnchantment.getName();
            String path = "Enchantments." + name;
            if (!enchants.contains(path)) continue;
            CEnchantment enchantment = new CEnchantment(name).setCustomName(enchants.getString(path + ".Name")).setActivated(enchants.getBoolean(path + ".Enabled")).setColor(enchants.getString(path + ".Color")).setBookColor(enchants.getString(path + ".BookColor")).setMaxLevel(enchants.getInt(path + ".MaxPower")).setEnchantmentType(cEnchantment.getType()).setInfoName(enchants.getString(path + ".Info.Name")).setInfoDescription(enchants.getStringList(path + ".Info.Description")).setCategories(enchants.getStringList(path + ".Categories")).setChance(cEnchantment.getChance()).setChanceIncrease(cEnchantment.getChanceIncrease());
            if (enchants.contains(path + ".Enchantment-Type")) {
                enchantment.setEnchantmentType(EnchantmentType.getFromName(enchants.getString(path + ".Enchantment-Type")));
            }
            if (cEnchantment.hasChanceSystem()) {
                if (enchants.contains(path + ".Chance-System.Base")) {
                    enchantment.setChance(enchants.getInt(path + ".Chance-System.Base"));
                } else {
                    enchantment.setChance(cEnchantment.getChance());
                }
                if (enchants.contains(path + ".Chance-System.Increase")) {
                    enchantment.setChanceIncrease(enchants.getInt(path + ".Chance-System.Increase"));
                } else {
                    enchantment.setChanceIncrease(cEnchantment.getChanceIncrease());
                }
            }
            enchantment.registerEnchantment();
        }
        if (this.gkitzToggle) {
            for (String kit : gkit.getConfigurationSection("GKitz").getKeys(false)) {
                String path = "GKitz." + kit + ".";
                int slot = gkit.getInt(path + "Display.Slot");
                String time = gkit.getString(path + "Cooldown");
                boolean autoEquip = gkit.getBoolean(path + "Auto-Equip");
                NBTItem displayItem = new NBTItem(new ItemBuilder().setMaterial(gkit.getString(path + "Display.Item")).setName(gkit.getString(path + "Display.Name")).setLore(gkit.getStringList(path + "Display.Lore")).setGlowing(gkit.getBoolean(path + "Display.Glowing")).build());
                displayItem.setString("gkit", kit);
                List commands = gkit.getStringList(path + "Commands");
                List itemStrings = gkit.getStringList(path + "Items");
                List<ItemStack> previewItems = this.getInfoGKit(itemStrings);
                previewItems.addAll(this.getInfoGKit(gkit.getStringList(path + "Fake-Items")));
                this.gkitz.add(new GKitz(kit, slot, time, displayItem.getItem(), previewItems, commands, itemStrings, autoEquip));
            }
        }
        Scrolls.loadScrolls();
        Dust.loadDust();
        ProtectionCrystal.loadProtectionCrystal();
        Scrambler.loadScrambler();
        ScrollControl.loadScrollControl();
        ShopOption.loadShopOptions();
        this.shopManager = ShopManager.getInstance();
        this.shopManager.load();
        this.wingsManager = WingsManager.getInstance();
        this.wingsManager.load();
        this.bowManager = BowEnchantmentManager.getInstance();
        this.bowManager.load();
        this.armorManager = ArmorEnchantmentManager.getInstance();
        this.armorManager.load();
        this.allyManager = AllyManager.getInstance();
        this.allyManager.load();
        Boots.startWings();
        if (Support.SupportedPlugins.WORLD_GUARD.isPluginLoaded() && Support.SupportedPlugins.WORLD_EDIT.isPluginLoaded()) {
            WorldGuardVersion worldGuardVersion = this.worldGuardVersion = this.useNewMaterial ? new WorldGuard_v7() : new WorldGuard_v6();
        }
        if (Support.SupportedPlugins.PLOT_SQUARED.isPluginLoaded()) {
            this.plotSquaredVersion = this.useNewMaterial ? new PlotSquared() : new PlotSquaredLegacy();
        }
        Support.getInstance().load();
    }

    public void loadCEPlayer(Player player) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = player.getUniqueId().toString();
        int souls = 0;
        boolean isActive = false;
        if (data.contains("Players." + uuid + ".Souls-Information")) {
            souls = data.getInt("Players." + uuid + ".Souls-Information.Souls");
            isActive = data.getBoolean("Players." + uuid + ".Souls-Information.Is-Active");
        }
        ArrayList<Cooldown> cooldowns = new ArrayList<Cooldown>();
        for (GKitz kit : this.getGKitz()) {
            if (!data.contains("Players." + uuid + ".GKitz." + kit.getName())) continue;
            Calendar cooldown = Calendar.getInstance();
            cooldown.setTimeInMillis(data.getLong("Players." + uuid + ".GKitz." + kit.getName()));
            cooldowns.add(new Cooldown(kit, cooldown));
        }
        this.addCEPlayer(new CEPlayer(player, souls, isActive, cooldowns));
    }

    public void unloadCEPlayer(Player player) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = player.getUniqueId().toString();
        CEPlayer p = this.getCEPlayer(player);
        if (p != null) {
            if (p.getSouls() > 0) {
                data.set("Players." + uuid + ".Name", (Object)player.getName());
                data.set("Players." + uuid + ".Souls-Information.Souls", (Object)p.getSouls());
                data.set("Players." + uuid + ".Souls-Information.Is-Active", (Object)p.isSoulsActive());
            }
            for (Cooldown cooldown : p.getCooldowns()) {
                data.set("Players." + uuid + ".GKitz." + cooldown.getGKitz().getName(), (Object)cooldown.getCooldown().getTimeInMillis());
            }
            FileManager.Files.DATA.saveFile();
        }
        this.removeCEPlayer(p);
    }

    public void backupCEPlayer(Player player) {
        this.backupCEPlayer(this.getCEPlayer(player));
    }

    public void backupCEPlayer(CEPlayer player) {
        FileConfiguration data = FileManager.Files.DATA.getFile();
        String uuid = player.getPlayer().getUniqueId().toString();
        if (player.getSouls() > 0) {
            data.set("Players." + uuid + ".Name", (Object)player.getPlayer().getName());
            data.set("Players." + uuid + ".Souls-Information.Souls", (Object)player.getSouls());
            data.set("Players." + uuid + ".Souls-Information.Is-Active", (Object)player.isSoulsActive());
        }
        for (Cooldown cooldown : player.getCooldowns()) {
            data.set("Players." + uuid + ".GKitz." + cooldown.getGKitz().getName(), (Object)cooldown.getCooldown().getTimeInMillis());
        }
        FileManager.Files.DATA.saveFile();
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public WorldGuardVersion getWorldGuardSupport() {
        return this.worldGuardVersion;
    }

    public PlotSquaredVersion getPlotSquaredSupport() {
        return this.plotSquaredVersion;
    }

    public NMSSupport getNMSSupport() {
        return this.nmsSupport;
    }

    public BlackSmithManager getBlackSmithManager() {
        return this.blackSmithManager;
    }

    public InfoMenuManager getInfoMenuManager() {
        return this.infoMenuManager;
    }

    public WingsManager getWingsManager() {
        return this.wingsManager;
    }

    public BowEnchantmentManager getBowManager() {
        return this.bowManager;
    }

    public ArmorEnchantmentManager getArmorManager() {
        return this.armorManager;
    }

    public AllyManager getAllyManager() {
        return this.allyManager;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public boolean useUnsafeEnchantments() {
        return this.useUnsafeEnchantments;
    }

    public boolean useMaxEnchantmentLimit() {
        return this.maxEnchantmentCheck;
    }

    public boolean checkVanillaLimit() {
        return this.checkVanillaLimit;
    }

    public boolean useNewMaterial() {
        return this.useNewMaterial;
    }

    public boolean useHealthAttributes() {
        return this.useHealthAttributes;
    }

    public Sound getSound(String newSound, String oldSound) {
        return Sound.valueOf((String)(this.useNewSounds ? newSound : oldSound));
    }

    public Material getMaterial(String newMaterial, String oldMaterial) {
        return Material.matchMaterial((String)(this.useNewMaterial ? newMaterial : oldMaterial));
    }

    public boolean isGkitzEnabled() {
        return this.gkitzToggle;
    }

    public GKitz getGKitFromName(String kitName) {
        for (GKitz kit : this.getGKitz()) {
            if (!kit.getName().equalsIgnoreCase(kitName)) continue;
            return kit;
        }
        return null;
    }

    public List<GKitz> getGKitz() {
        return this.gkitz;
    }

    public void addGKit(GKitz kit) {
        this.gkitz.add(kit);
    }

    public void removeGKit(GKitz kit) {
        this.gkitz.remove(kit);
    }

    public CEPlayer getCEPlayer(Player player) {
        for (CEPlayer p : this.getCEPlayers()) {
            if (p.getPlayer() != player) continue;
            return p;
        }
        return null;
    }

    public List<CEPlayer> getCEPlayers() {
        return this.players;
    }

    public ItemBuilder getEnchantmentBook() {
        return this.enchantmentBook.clone();
    }

    public ItemStack getEnchantmentBookItem() {
        return this.enchantmentBook.build();
    }

    public boolean hasEnchantments(ItemStack item) {
        for (CEnchantment enchantment : this.registeredEnchantments) {
            if (!this.hasEnchantment(item, enchantment)) continue;
            return true;
        }
        return false;
    }

    public boolean hasEnchantment(ItemStack item, CEnchantment enchantment) {
        if (Methods.verifyItemLore(item)) {
            ItemMeta meta = item.getItemMeta();
            List itemLore = meta.getLore();
            if (enchantment.isActivated() && itemLore != null) {
                for (String lore : itemLore) {
                    String[] split = lore.split(" ");
                    if (!lore.replace(" " + split[split.length - 1], "").equals(enchantment.getColor() + enchantment.getCustomName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasEnchantment(ItemStack item, CEnchantments enchantment) {
        return this.hasEnchantment(item, enchantment.getEnchantment());
    }

    public Category getHighestEnchantmentCategory(CEnchantment enchantment) {
        Category topCategory = null;
        int rarity = 0;
        for (Category category : enchantment.getCategories()) {
            if (category.getRarity() < rarity) continue;
            rarity = category.getRarity();
            topCategory = category;
        }
        return topCategory;
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public Category getCategory(String name) {
        for (Category category : this.categories) {
            if (!category.getName().equalsIgnoreCase(name)) continue;
            return category;
        }
        return null;
    }

    public Category getCategoryFromLostBook(ItemStack item) {
        for (Category category : this.categories) {
            if (!item.isSimilar(category.getLostBook().getLostBook(category).build())) continue;
            return category;
        }
        return null;
    }

    public CEBook getRandomEnchantmentBook(Category category) {
        try {
            List<CEnchantment> enchantments = category.getEnabledEnchantments();
            CEnchantment enchantment = enchantments.get(this.random.nextInt(enchantments.size()));
            return new CEBook(enchantment, this.randomLevel(enchantment, category), 1, category);
        }
        catch (Exception e) {
            System.out.println("[Crazy Enchantments]>> The category " + category.getName() + " has no enchantments. Please add enchantments to the category in the Enchantments.yml. If you do not wish to have the category feel free to delete it from the Config.yml.");
            return null;
        }
    }

    public boolean playerHasEnchantmentOn(Player player, ItemStack includeItem, ItemStack excludeItem, CEnchantment enchantment) {
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            if (armor.isSimilar(excludeItem) || !this.hasEnchantment(armor, enchantment)) continue;
            return true;
        }
        return this.hasEnchantment(includeItem, enchantment);
    }

    public boolean playerHasEnchantmentOnExclude(Player player, ItemStack excludedItem, CEnchantment enchantment) {
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            if (armor.isSimilar(excludedItem) || !this.hasEnchantment(armor, enchantment)) continue;
            return true;
        }
        return false;
    }

    public boolean playerHasEnchantmentOnInclude(Player player, ItemStack includedItem, CEnchantment enchantment) {
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            if (!this.hasEnchantment(armor, enchantment)) continue;
            return true;
        }
        return this.hasEnchantment(includedItem, enchantment);
    }

    public int getHighestEnchantmentLevel(Player player, ItemStack includedItem, ItemStack excludedItem, CEnchantment enchantment) {
        int level;
        int highest = 0;
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            int level2;
            if (armor.isSimilar(excludedItem) || !this.hasEnchantment(armor, enchantment) || highest >= (level2 = this.getLevel(armor, enchantment))) continue;
            highest = level2;
        }
        if (this.hasEnchantment(includedItem, enchantment) && highest < (level = this.getLevel(includedItem, enchantment))) {
            highest = level;
        }
        return highest;
    }

    public int getHighestEnchantmentLevelExclude(Player player, ItemStack excludedItem, CEnchantment enchantment) {
        int highest = 0;
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            int level;
            if (armor.isSimilar(excludedItem) || !this.hasEnchantment(armor, enchantment) || highest >= (level = this.getLevel(armor, enchantment))) continue;
            highest = level;
        }
        return highest;
    }

    public int getHighestEnchantmentLevelInclude(Player player, ItemStack includedItem, CEnchantment enchantment) {
        int level;
        int highest = 0;
        for (ItemStack armor : player.getEquipment().getArmorContents()) {
            int level2;
            if (!this.hasEnchantment(armor, enchantment) || highest >= (level2 = this.getLevel(armor, enchantment))) continue;
            highest = level2;
        }
        if (this.hasEnchantment(includedItem, enchantment) && highest < (level = this.getLevel(includedItem, enchantment))) {
            highest = level;
        }
        return highest;
    }

    public List<CEnchantment> getRegisteredEnchantments() {
        return new ArrayList<CEnchantment>(this.registeredEnchantments);
    }

    public CEnchantment getEnchantmentFromName(String enchantmentString) {
        enchantmentString = Methods.stripString(enchantmentString);
        for (CEnchantment enchantment : this.registeredEnchantments) {
            if (!Methods.stripString(enchantment.getName()).equalsIgnoreCase(enchantmentString) && !Methods.stripString(enchantment.getCustomName()).equalsIgnoreCase(enchantmentString)) continue;
            return enchantment;
        }
        return null;
    }

    public void registerEnchantment(CEnchantment enchantment) {
        this.registeredEnchantments.add(enchantment);
    }

    public void unregisterEnchantment(CEnchantment enchantment) {
        this.registeredEnchantments.remove(enchantment);
    }

    public ItemStack addEnchantment(ItemStack item, CEnchantment enchantment, int level) {
        HashMap<CEnchantment, Integer> enchantments = new HashMap<CEnchantment, Integer>();
        enchantments.put(enchantment, level);
        return this.addEnchantments(item, enchantments);
    }

    public ItemStack addEnchantments(ItemStack item, Map<CEnchantment, Integer> enchantments) {
        for (Map.Entry<CEnchantment, Integer> entry : enchantments.entrySet()) {
            List itemLore;
            CEnchantment enchantment = entry.getKey();
            int level = entry.getValue();
            if (this.hasEnchantment(item, enchantment)) {
                this.removeEnchantment(item, enchantment);
            }
            ArrayList<Object> newLore = new ArrayList<Object>();
            ArrayList lores = new ArrayList();
            HashMap<String, String> enchantmentStrings = new HashMap<String, String>();
            for (CEnchantment en : this.getEnchantmentsOnItem(item)) {
                enchantmentStrings.put(en.getName(), Methods.color(en.getColor() + en.getCustomName() + " " + this.convertLevelString(this.getLevel(item, en))));
                this.removeEnchantment(item, en);
            }
            ItemMeta meta = item.getItemMeta();
            if (meta != null && meta.hasLore() && (itemLore = meta.getLore()) != null) {
                lores.addAll(itemLore);
            }
            enchantmentStrings.put(enchantment.getName(), Methods.color(enchantment.getColor() + enchantment.getCustomName() + " " + this.convertLevelString(level)));
            for (Map.Entry stringEntry : enchantmentStrings.entrySet()) {
                newLore.add(stringEntry.getValue());
            }
            newLore.addAll(lores);
            if (meta != null) {
                meta.setLore(newLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack removeEnchantment(ItemStack item, CEnchantment enchant) {
        List itemLore;
        ArrayList<String> newLore = new ArrayList<String>();
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasLore() && (itemLore = meta.getLore()) != null) {
            for (String lore : itemLore) {
                if (lore.contains(enchant.getCustomName())) continue;
                newLore.add(lore);
            }
        }
        if (meta != null) {
            meta.setLore(newLore);
        }
        item.setItemMeta(meta);
        return item;
    }

    public List<CEnchantment> getEnchantmentsOnItem(ItemStack item) {
        return new ArrayList<CEnchantment>(this.getEnchantments(item).keySet());
    }

    public Map<CEnchantment, Integer> getEnchantments(ItemStack item) {
        if (!Methods.verifyItemLore(item)) {
            return Collections.emptyMap();
        }
        List lore = item.getItemMeta().getLore();
        Map<CEnchantment, Integer> enchantments = null;
        block0: for (String line : lore) {
            int lastSpaceIndex = line.lastIndexOf(32);
            if (lastSpaceIndex < 1 || lastSpaceIndex + 1 > line.length()) continue;
            String enchantmentName = line.substring(0, lastSpaceIndex);
            for (CEnchantment enchantment : this.registeredEnchantments) {
                if (!enchantment.isActivated() || !enchantmentName.equals(enchantment.getColor() + enchantment.getCustomName())) continue;
                String levelString = line.substring(lastSpaceIndex + 1);
                int level = this.convertLevelInteger(levelString);
                if (level < 1) continue block0;
                if (enchantments == null) {
                    enchantments = new HashMap<CEnchantment, Integer>();
                }
                enchantments.put(enchantment, level);
                continue block0;
            }
        }
        if (enchantments == null) {
            enchantments = Collections.emptyMap();
        }
        return enchantments;
    }

    public int getEnchantmentAmount(ItemStack item) {
        int amount = this.getEnchantmentsOnItem(item).size();
        if (this.checkVanillaLimit && item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            amount += item.getItemMeta().getEnchants().size();
        }
        return amount;
    }

    public boolean hasWhiteScrollProtection(ItemStack item) {
        List itemLore;
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.hasLore() && (itemLore = meta.getLore()) != null) {
            for (String lore : itemLore) {
                if (!lore.equals(this.whiteScrollProtectionName)) continue;
                return true;
            }
        }
        return false;
    }

    public ItemStack addWhiteScrollProtection(ItemStack item) {
        return ItemBuilder.convertItemStack(item).addLore(this.whiteScrollProtectionName).build();
    }

    public ItemStack removeWhiteScrollProtection(ItemStack item) {
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta != null && itemMeta.hasLore()) {
            ArrayList newLore = new ArrayList(Objects.requireNonNull(itemMeta.getLore()));
            newLore.remove(this.whiteScrollProtectionName);
            itemMeta.setLore(newLore);
            item.setItemMeta(itemMeta);
        }
        return item;
    }

    public void updatePlayerEffects(Player player) {
        if (player != null) {
            for (CEnchantments ench : this.getEnchantmentPotions().keySet()) {
                for (ItemStack armor : player.getEquipment().getArmorContents()) {
                    if (!ench.isActivated() || !this.hasEnchantment(armor, ench.getEnchantment())) continue;
                    Map<PotionEffectType, Integer> effects = this.getUpdatedEffects(player, armor, new ItemStack(Material.AIR), ench);
                    for (Map.Entry<PotionEffectType, Integer> type : effects.entrySet()) {
                        if (type.getValue() < 0) {
                            player.removePotionEffect(type.getKey());
                            continue;
                        }
                        player.removePotionEffect(type.getKey());
                        player.addPotionEffect(new PotionEffect(type.getKey(), Integer.MAX_VALUE, type.getValue().intValue()));
                    }
                }
            }
        }
    }

    public Map<PotionEffectType, Integer> getUpdatedEffects(Player player, ItemStack includedItem, ItemStack excludedItem, CEnchantments enchantment) {
        HashMap<PotionEffectType, Integer> effects = new HashMap<PotionEffectType, Integer>();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(player.getEquipment().getArmorContents()));
        if (includedItem == null) {
            includedItem = new ItemStack(Material.AIR);
        }
        if (excludedItem == null) {
            excludedItem = new ItemStack(Material.AIR);
        }
        if (excludedItem.isSimilar(includedItem)) {
            excludedItem = new ItemStack(Material.AIR);
        }
        items.add(includedItem);
        Map<CEnchantments, HashMap<PotionEffectType, Integer>> armorEffects = this.getEnchantmentPotions();
        for (Map.Entry<CEnchantments, HashMap<PotionEffectType, Integer>> enchantments : armorEffects.entrySet()) {
            for (ItemStack armor : items) {
                if (armor == null || armor.isSimilar(excludedItem) || !this.hasEnchantment(armor, enchantments.getKey().getEnchantment())) continue;
                int level = this.getLevel(armor, enchantments.getKey().getEnchantment());
                if (!this.useUnsafeEnchantments && level > enchantments.getKey().getEnchantment().getMaxLevel()) {
                    level = enchantments.getKey().getEnchantment().getMaxLevel();
                }
                for (PotionEffectType type : enchantments.getValue().keySet()) {
                    if (!enchantments.getValue().containsKey(type)) continue;
                    if (effects.containsKey(type)) {
                        int updated = effects.get(type);
                        if (updated >= level + enchantments.getValue().get(type)) continue;
                        effects.put(type, level + enchantments.getValue().get(type));
                        continue;
                    }
                    effects.put(type, level + enchantments.getValue().get(type));
                }
            }
        }
        for (PotionEffectType type : armorEffects.get((Object)enchantment).keySet()) {
            if (effects.containsKey(type)) continue;
            effects.put(type, -1);
        }
        return effects;
    }

    public Map<CEnchantments, HashMap<PotionEffectType, Integer>> getEnchantmentPotions() {
        HashMap<CEnchantments, HashMap<PotionEffectType, Integer>> enchants = new HashMap<CEnchantments, HashMap<PotionEffectType, Integer>>();
        enchants.put(CEnchantments.GLOWING, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.GLOWING)).put(PotionEffectType.NIGHT_VISION, -1);
        enchants.put(CEnchantments.MERMAID, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.MERMAID)).put(PotionEffectType.WATER_BREATHING, -1);
        enchants.put(CEnchantments.BURNSHIELD, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.BURNSHIELD)).put(PotionEffectType.FIRE_RESISTANCE, -1);
        enchants.put(CEnchantments.DRUNK, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.INCREASE_DAMAGE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.SLOW_DIGGING, -1);
        ((HashMap)enchants.get((Object)CEnchantments.DRUNK)).put(PotionEffectType.SLOW, 0);
        enchants.put(CEnchantments.HULK, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.INCREASE_DAMAGE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.DAMAGE_RESISTANCE, -1);
        ((HashMap)enchants.get((Object)CEnchantments.HULK)).put(PotionEffectType.SLOW, 0);
        enchants.put(CEnchantments.VALOR, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.VALOR)).put(PotionEffectType.DAMAGE_RESISTANCE, -1);
        enchants.put(CEnchantments.OVERLOAD, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.OVERLOAD)).put(PotionEffectType.HEALTH_BOOST, 0);
        enchants.put(CEnchantments.NINJA, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.NINJA)).put(PotionEffectType.HEALTH_BOOST, -1);
        ((HashMap)enchants.get((Object)CEnchantments.NINJA)).put(PotionEffectType.SPEED, -1);
        enchants.put(CEnchantments.INSOMNIA, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.CONFUSION, -1);
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.SLOW_DIGGING, -1);
        ((HashMap)enchants.get((Object)CEnchantments.INSOMNIA)).put(PotionEffectType.SLOW, 0);
        enchants.put(CEnchantments.ANTIGRAVITY, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.ANTIGRAVITY)).put(PotionEffectType.JUMP, 1);
        enchants.put(CEnchantments.GEARS, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.GEARS)).put(PotionEffectType.SPEED, -1);
        enchants.put(CEnchantments.SPRINGS, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.SPRINGS)).put(PotionEffectType.JUMP, -1);
        enchants.put(CEnchantments.CYBORG, new HashMap());
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.SPEED, -1);
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.INCREASE_DAMAGE, 0);
        ((HashMap)enchants.get((Object)CEnchantments.CYBORG)).put(PotionEffectType.JUMP, 0);
        return enchants;
    }

    public CEBook getCEBook(ItemStack book) {
        try {
            return new CEBook(this.getEnchantmentBookEnchantment(book), this.getBookLevel(book, this.getEnchantmentBookEnchantment(book)), book.getAmount()).setSuccessRate(Methods.getPercent("%success_rate%", book, FileManager.Files.CONFIG.getFile().getStringList("Settings.EnchantmentBookLore"), 100)).setDestroyRate(Methods.getPercent("%destroy_rate%", book, FileManager.Files.CONFIG.getFile().getStringList("Settings.EnchantmentBookLore"), 0));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isEnchantmentBook(ItemStack book) {
        if (book != null && book.getType() == this.enchantmentBook.getMaterial() && book.hasItemMeta() && book.getItemMeta().hasDisplayName()) {
            for (CEnchantment enchantment : this.registeredEnchantments) {
                String bookNameCheck = book.getItemMeta().getDisplayName();
                String[] split = bookNameCheck.split(" ");
                if (!bookNameCheck.replace(" " + split[split.length - 1], "").equals(enchantment.getBookColor() + enchantment.getCustomName())) continue;
                return true;
            }
        }
        return false;
    }

    public CEnchantment getEnchantmentBookEnchantment(ItemStack book) {
        if (book != null && book.getType() == this.enchantmentBook.getMaterial() && book.hasItemMeta() && book.getItemMeta().hasDisplayName()) {
            for (CEnchantment enchantment : this.registeredEnchantments) {
                String bookNameCheck = book.getItemMeta().getDisplayName();
                String[] split = bookNameCheck.split(" ");
                if (!bookNameCheck.replace(" " + split[split.length - 1], "").equals(enchantment.getBookColor() + enchantment.getCustomName())) continue;
                return enchantment;
            }
        }
        return null;
    }

    public int getPlayerMaxEnchantments(Player player) {
        int limit = 0;
        for (PermissionAttachmentInfo Permission2 : player.getEffectivePermissions()) {
            String perm = Permission2.getPermission().toLowerCase();
            if (!perm.startsWith("crazyenchantments.limit.") || !Methods.isInt(perm = perm.replace("crazyenchantments.limit.", "")) || limit >= Integer.parseInt(perm)) continue;
            limit = Integer.parseInt(perm);
        }
        return limit;
    }

    public boolean canAddEnchantment(Player player, ItemStack item) {
        if (this.maxEnchantmentCheck && !player.hasPermission("crazyenchantments.bypass.limit")) {
            return this.getEnchantmentAmount(item) < this.getPlayerMaxEnchantments(player);
        }
        return true;
    }

    public int getBookLevel(ItemStack book, CEnchantment enchant) {
        return this.convertLevelInteger(book.getItemMeta().getDisplayName().replace(enchant.getBookColor() + enchant.getCustomName() + " ", ""));
    }

    public int getLevel(ItemStack item, CEnchantment enchant) {
        List itemLore;
        ItemMeta meta;
        String line = "";
        if (Methods.verifyItemLore(item) && (meta = item.getItemMeta()) != null && meta.hasLore() && (itemLore = meta.getLore()) != null) {
            for (String lore : itemLore) {
                if (!lore.contains(enchant.getCustomName())) continue;
                line = lore;
                break;
            }
        }
        int level = this.convertLevelInteger(line.replace(enchant.getColor() + enchant.getCustomName() + " ", ""));
        if (!this.useUnsafeEnchantments && level > enchant.getMaxLevel()) {
            level = enchant.getMaxLevel();
        }
        return level;
    }

    public int getLevel(ItemStack item, CEnchantments enchant) {
        List itemLore;
        ItemMeta meta;
        String line = "";
        if (Methods.verifyItemLore(item) && (meta = item.getItemMeta()) != null && meta.hasLore() && (itemLore = meta.getLore()) != null) {
            for (String lore : itemLore) {
                if (!lore.contains(enchant.getCustomName())) continue;
                line = lore;
                break;
            }
        }
        int level = this.convertLevelInteger(line.replace(enchant.getEnchantment().getColor() + enchant.getCustomName() + " ", ""));
        if (!this.useUnsafeEnchantments && level > enchant.getEnchantment().getMaxLevel()) {
            level = enchant.getEnchantment().getMaxLevel();
        }
        return level;
    }

    public int randomLevel(CEnchantment enchantment, Category category) {
        int enchantmentMax = enchantment.getMaxLevel();
        int randomLevel = 1 + this.random.nextInt(enchantmentMax);
        if (category.useMaxLevel()) {
            if (randomLevel > category.getMaxLevel()) {
                randomLevel = 1 + this.random.nextInt(enchantmentMax);
            }
            if (randomLevel < category.getMinLevel()) {
                randomLevel = category.getMinLevel();
            }
            if (randomLevel > enchantmentMax) {
                randomLevel = enchantmentMax;
            }
        }
        return randomLevel;
    }

    public List<Material> getBlockList() {
        return this.blockList;
    }

    public List<Event> getIgnoredEvents() {
        return this.ignoredEvents;
    }

    public boolean isIgnoredEvent(Event event) {
        return this.ignoredEvents.contains(event);
    }

    public void addIgnoredEvent(Event event) {
        if (!this.ignoredEvents.contains(event)) {
            this.ignoredEvents.add(event);
        }
    }

    public void removeIgnoredUUID(UUID uuid) {
        this.ignoredUUIDs.remove(uuid);
    }

    public List<UUID> getIgnoredUUIDs() {
        return this.ignoredUUIDs;
    }

    public boolean isIgnoredUUID(UUID uuid) {
        return this.ignoredUUIDs.contains(uuid);
    }

    public void addIgnoredUUID(UUID uuid) {
        if (!this.ignoredUUIDs.contains(uuid)) {
            this.ignoredUUIDs.add(uuid);
        }
    }

    public void removeIgnoredEvent(Event event) {
        this.ignoredEvents.remove(event);
    }

    public int getRageMaxLevel() {
        return this.rageMaxLevel;
    }

    public void setRageMaxLevel(int level) {
        this.rageMaxLevel = level;
    }

    public void setBreakRageOnDamage(boolean toggle) {
        this.breakRageOnDamage = toggle;
    }

    public boolean isBreakRageOnDamageOn() {
        return this.breakRageOnDamage;
    }

    public boolean enchantStackedItems() {
        return this.enchantStackedItems;
    }

    public String convertLevelString(int i) {
        switch (i) {
            case 0: 
            case 1: {
                return "I";
            }
            case 2: {
                return "II";
            }
            case 3: {
                return "III";
            }
            case 4: {
                return "IV";
            }
            case 5: {
                return "V";
            }
            case 6: {
                return "VI";
            }
            case 7: {
                return "VII";
            }
            case 8: {
                return "VIII";
            }
            case 9: {
                return "IX";
            }
            case 10: {
                return "X";
            }
        }
        return i + "";
    }

    public int convertLevelInteger(String i) {
        switch (i) {
            case "I": {
                return 1;
            }
            case "II": {
                return 2;
            }
            case "III": {
                return 3;
            }
            case "IV": {
                return 4;
            }
            case "V": {
                return 5;
            }
            case "VI": {
                return 6;
            }
            case "VII": {
                return 7;
            }
            case "VIII": {
                return 8;
            }
            case "IX": {
                return 9;
            }
            case "X": {
                return 10;
            }
        }
        if (Methods.isInt(i)) {
            return Integer.parseInt(i);
        }
        return 0;
    }

    private void addCEPlayer(CEPlayer player) {
        this.players.add(player);
    }

    private void removeCEPlayer(CEPlayer player) {
        this.players.remove(player);
    }

    /*
     * WARNING - void declaration
     */
    private List<ItemStack> getInfoGKit(List<String> itemStrings) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String itemString : itemStrings) {
            StringBuilder newItemString = new StringBuilder();
            for (String string : itemString.split(", ")) {
                void var9_15;
                if (string.toLowerCase().startsWith("enchantments:") || string.toLowerCase().startsWith("customenchantments:")) {
                    StringBuilder newOption = new StringBuilder();
                    for (String enchantment : string.toLowerCase().replace("customenchantments:", "").replace("enchantments:", "").split(",")) {
                        newOption.append(enchantment).append(", ");
                    }
                    String string2 = newOption.substring(0, newOption.length() - 2);
                }
                newItemString.append((String)var9_15).append(", ");
            }
            if (newItemString.length() > 0) {
                itemString = newItemString.substring(0, newItemString.length() - 2);
            }
            ItemBuilder itemBuilder = ItemBuilder.convertString(itemString);
            ArrayList<String> customEnchantments = new ArrayList<String>();
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            for (String option3 : itemString.split(", ")) {
                try {
                    Enchantment enchantment = Methods.getEnchantment(option3.split(":")[0]);
                    CEnchantment cEnchantment = this.getEnchantmentFromName(option3.split(":")[0]);
                    String level = option3.split(":")[1];
                    if (enchantment != null) {
                        if (level.contains("-")) {
                            customEnchantments.add("&7" + option3.split(":")[0] + " " + level);
                            continue;
                        }
                        enchantments.put(enchantment, Integer.parseInt(level));
                        continue;
                    }
                    if (cEnchantment == null) continue;
                    customEnchantments.add(cEnchantment.getColor() + cEnchantment.getCustomName() + " " + level);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            itemBuilder.getLore().addAll(0, customEnchantments);
            itemBuilder.setEnchantments(enchantments);
            NBTItem nBTItem = new NBTItem(itemBuilder.build());
            nBTItem.setInteger("random-number", this.random.nextInt(Integer.MAX_VALUE));
            items.add(nBTItem.getItem());
        }
        return items;
    }

    public int pickLevel(int min, int max) {
        return min + this.random.nextInt(max + 1 - min);
    }

    private List<Color> getColors(String string) {
        ArrayList<Color> colors = new ArrayList<Color>();
        if (string.contains(", ")) {
            for (String name : string.split(", ")) {
                Color color = Methods.getColor(name);
                if (color == null) continue;
                colors.add(color);
            }
        } else {
            Color color = Methods.getColor(string);
            if (color != null) {
                colors.add(color);
            }
        }
        return colors;
    }
}

