/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.util;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.bukkit.plugin.Plugin;

public final class DebugLogHandler
extends Handler {
    private static final String DEFAULT_DEBUG_PREFIX_FORMAT = "[%1$s-%2$s] %3$s";
    private static final String DEFAULT_DEBUG_LOG_PREFIX = "DEBUG";
    private final Plugin plugin;
    private final String pluginName;

    private DebugLogHandler(Plugin plugin) {
        this.plugin = plugin;
        String prefix = plugin.getDescription().getPrefix();
        this.pluginName = prefix != null ? prefix : plugin.getDescription().getName();
    }

    public static void attachDebugLogger(Plugin plugin) {
        plugin.getLogger().addHandler(new DebugLogHandler(plugin));
    }

    @Override
    public void publish(LogRecord record) {
        if (this.plugin.getLogger().getLevel().intValue() <= record.getLevel().intValue() && record.getLevel().intValue() < Level.INFO.intValue()) {
            record.setLevel(Level.INFO);
            record.setMessage(String.format(DEFAULT_DEBUG_PREFIX_FORMAT, this.pluginName, DEFAULT_DEBUG_LOG_PREFIX, record.getMessage().substring(this.pluginName.length() + 3)));
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

