/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.configuration.file.YamlConstructor;
import org.bukkit.configuration.file.YamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public class CommentedConfiguration
extends YamlConfiguration {
    private final HashMap<String, String> comments;
    private final File file;
    private final DumperOptions yamlOptions = new DumperOptions();
    private final Representer yamlRepresenter = new YamlRepresenter();
    private Yaml yaml;

    public CommentedConfiguration(File file) {
        try {
            LoaderOptions loaderOptions = new LoaderOptions();
            loaderOptions.setMaxAliasesForCollections(100);
            this.yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions, loaderOptions);
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            this.yaml = new Yaml((BaseConstructor)new YamlConstructor(), this.yamlRepresenter, this.yamlOptions);
        }
        this.comments = new HashMap();
        this.file = file;
    }

    public String saveToString() {
        this.yamlOptions.setIndent(this.options().indent());
        this.yamlOptions.setDefaultScalarStyle(DumperOptions.ScalarStyle.LITERAL);
        this.yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        String dump = this.yaml.dump((Object)this.getValues(false));
        if (dump.equals("{}\n")) {
            dump = "";
        }
        return dump;
    }

    public boolean load() {
        boolean loaded = true;
        try {
            this.load(this.file);
        }
        catch (IOException | InvalidConfigurationException e) {
            loaded = false;
            System.out.println("Exception while loading the file: " + e.getMessage());
            e.printStackTrace();
        }
        return loaded;
    }

    public boolean save() {
        boolean saved = true;
        try {
            super.save(this.file);
        }
        catch (IOException e) {
            saved = false;
            System.out.println("Failed to save the file: " + e.getMessage());
            e.printStackTrace();
        }
        if (!this.comments.isEmpty() && saved) {
            String[] yamlContents = this.convertFileToString(this.file).split("[" + System.lineSeparator() + "]");
            String newContents = "";
            String currentPath = "";
            boolean commentedPath = false;
            int depth = 0;
            for (String line : yamlContents) {
                boolean node;
                if (line.contains(": ") || line.length() > 1 && line.charAt(line.length() - 1) == ':') {
                    commentedPath = false;
                    node = true;
                    int index = line.indexOf(": ");
                    if (index < 0) {
                        index = line.length() - 1;
                    }
                    if (currentPath.isEmpty()) {
                        currentPath = line.substring(0, index);
                    } else {
                        int whiteSpace = 0;
                        for (int n = 0; n < line.length() && line.charAt(n) == ' '; ++n) {
                            ++whiteSpace;
                        }
                        if (whiteSpace / 2 > depth) {
                            currentPath = currentPath + "." + line.substring(whiteSpace, index);
                            ++depth;
                        } else if (whiteSpace / 2 < depth) {
                            int newDepth = whiteSpace / 2;
                            for (int i = 0; i < depth - newDepth; ++i) {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(46)), "");
                            }
                            int lastIndex = currentPath.lastIndexOf(46);
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(46)), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                            depth = newDepth;
                        } else {
                            int lastIndex = currentPath.lastIndexOf(46);
                            if (lastIndex < 0) {
                                currentPath = "";
                            } else {
                                currentPath = currentPath.replace(currentPath.substring(currentPath.lastIndexOf(46)), "");
                                currentPath = currentPath + ".";
                            }
                            currentPath = currentPath + line.substring(whiteSpace, index);
                        }
                    }
                } else {
                    node = false;
                }
                if (node) {
                    String comment = null;
                    if (!commentedPath) {
                        comment = this.comments.get(currentPath);
                    }
                    if (comment != null) {
                        line = comment + System.lineSeparator() + line + System.lineSeparator();
                        commentedPath = true;
                    } else {
                        line = line + System.lineSeparator();
                    }
                }
                newContents = newContents + line + (!node ? System.lineSeparator() : "");
            }
            while (newContents.startsWith(System.lineSeparator())) {
                newContents = newContents.replaceFirst(System.lineSeparator(), "");
            }
            if (!this.writeStringToFile(newContents, this.file)) {
                saved = false;
            }
        }
        return saved;
    }

    public void addComment(String path, String ... commentLines) {
        StringBuilder commentstring = new StringBuilder();
        String leadingSpaces = "";
        for (int n = 0; n < path.length(); ++n) {
            if (path.charAt(n) != '.') continue;
            leadingSpaces = leadingSpaces + "  ";
        }
        for (int index = 0; index < commentLines.length; ++index) {
            String line = commentLines[index];
            if (!line.isEmpty()) {
                line = leadingSpaces + line;
            }
            commentstring.append(line);
            if (index + 1 == commentLines.length) continue;
            commentstring.append(System.lineSeparator());
        }
        this.comments.put(path, commentstring.toString());
    }

    public String convertFileToString(File fileToConvert) {
        if (fileToConvert != null && fileToConvert.exists() && fileToConvert.canRead() && !fileToConvert.isDirectory()) {
            char[] buffer = new char[1024];
            String s = "";
            try (StringWriter writer = new StringWriter();
                 BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileToConvert), StandardCharsets.UTF_8));){
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
                s = ((Object)writer).toString();
            }
            catch (IOException e) {
                System.out.println("Failed to convert the file to a string: " + e.getMessage());
                e.printStackTrace();
            }
            return s;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean writeStringToFile(String source, File fileToWriteTo) {
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fileToWriteTo), StandardCharsets.UTF_8);){
            out.write(source);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            System.out.println("Failed to convert the string to a file: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }
}

