/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.listeners;

import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.massivecore.ps.PS;
import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.events.SilkSpawnersSpawnerChangeEvent;
import de.dustplanet.util.SilkUtil;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SilkSpawnersPlayerListener
implements Listener {
    private final SilkSpawners plugin;
    private final SilkUtil su;

    public SilkSpawnersPlayerListener(SilkSpawners instance, SilkUtil util) {
        this.plugin = instance;
        this.su = util;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerHoldItem(PlayerItemHeldEvent event) {
        if (event.getPlayer().getInventory().getItem(event.getNewSlot()) != null && event.getPlayer().getInventory().getItem(event.getNewSlot()).getType() == this.su.nmsProvider.getSpawnerMaterial() && this.plugin.config.getBoolean("notifyOnHold") && event.getPlayer().hasPermission("silkspawners.info")) {
            String entityID = this.su.getStoredSpawnerItemEntityID(event.getPlayer().getInventory().getItem(event.getNewSlot()));
            if (entityID == null) {
                entityID = this.su.getDefaultEntityID();
            }
            String spawnerName = this.su.getCreatureName(entityID);
            Player player = event.getPlayer();
            this.su.notify(player, spawnerName);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.hasItem() || !event.hasBlock()) {
            return;
        }
        ItemStack item = event.getItem();
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        Player player = event.getPlayer();
        if (item != null && this.su.nmsProvider.getSpawnEggMaterials().contains(item.getType())) {
            String entityID = this.su.getStoredEggEntityID(item);
            boolean disableChangeTypeWithEgg = this.plugin.config.getBoolean("disableChangeTypeWithEgg", false);
            if (block.getType() == this.su.nmsProvider.getSpawnerMaterial()) {
                Action action = event.getAction();
                if (action != Action.LEFT_CLICK_BLOCK && action != Action.RIGHT_CLICK_BLOCK) {
                    return;
                }
                if (!disableChangeTypeWithEgg) {
                    if (!this.su.canBuildHere(player, block.getLocation())) {
                        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changingDeniedWorldGuard")));
                        return;
                    }
                    if (!this.checkIfFactionsPermitsBlockInteractions(player, block)) {
                        event.setCancelled(true);
                        return;
                    }
                    if (!this.su.hasPermission((Permissible)player, "silkspawners.changetypewithegg.", entityID)) {
                        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionChangingWithEggs")));
                        event.setCancelled(true);
                        return;
                    }
                    SilkSpawnersSpawnerChangeEvent changeEvent = new SilkSpawnersSpawnerChangeEvent(player, block, entityID, this.su.getSpawnerEntityID(block), 1);
                    this.plugin.getServer().getPluginManager().callEvent((Event)changeEvent);
                    if (changeEvent.isCancelled()) {
                        event.setCancelled(true);
                        return;
                    }
                    entityID = changeEvent.getEntityID();
                    this.su.setSpawnerType(block, entityID, player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changingDeniedWorldGuard")));
                    this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changedSpawner")).replace("%creature%", this.su.getCreatureName(entityID)));
                    if (this.plugin.config.getBoolean("consumeEgg", true)) {
                        this.su.nmsProvider.reduceEggs(player);
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                }
            }
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK || event.getAction() == Action.RIGHT_CLICK_AIR) {
                if (this.plugin.config.getBoolean("spawnEggToSpawner", false)) {
                    if (!this.checkIfFactionsPermitsBlockInteractions(player, block)) {
                        event.setCancelled(true);
                        return;
                    }
                    Block targetBlock = block.getRelative(BlockFace.UP);
                    if (targetBlock.getType() == Material.AIR) {
                        targetBlock.setType(this.su.nmsProvider.getSpawnerMaterial());
                        this.su.setSpawnerEntityID(targetBlock, entityID);
                        if (this.plugin.config.getBoolean("consumeEgg", true)) {
                            this.su.nmsProvider.reduceEggs(player);
                        }
                    } else {
                        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noSpawnerHere")));
                    }
                    event.setCancelled(true);
                } else if (this.plugin.config.getBoolean("spawnEggOverride", false)) {
                    boolean allowed = this.plugin.config.getBoolean("spawnEggOverrideSpawnDefault", true);
                    if (entityID != null) {
                        allowed = this.plugin.mobs.getBoolean("creatures." + entityID + ".enableSpawnEggOverrideAllowSpawn", allowed);
                    }
                    if (!allowed) {
                        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawningDenied").replace("%ID%", entityID)).replace("%creature%", this.su.getCreatureName(entityID)));
                        event.setCancelled(true);
                        return;
                    }
                    this.plugin.informPlayer(player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("spawning").replace("%ID%", entityID)).replace("%creature%", this.su.getCreatureName(entityID)));
                    Location location = block.getLocation();
                    location.add(0.5, 1.0, 0.5);
                    double x = location.getX();
                    double y = location.getY();
                    double z = location.getZ();
                    this.su.nmsProvider.spawnEntity(player.getWorld(), entityID, x, y, z, player);
                    this.su.nmsProvider.reduceEggs(player);
                    event.setCancelled(true);
                }
            }
        }
    }

    public boolean checkIfFactionsPermitsBlockInteractions(Player player, Block block) {
        block4: {
            if (this.plugin.config.getBoolean("factionsSupport", false) && this.su.isPluginEnabled("Factions")) {
                try {
                    MPlayer mp = MPlayer.get((Object)player);
                    com.massivecraft.factions.entity.Faction blockFaction = BoardColl.get().getFactionAt(PS.valueOf((Location)block.getLocation()));
                    if (!blockFaction.isNone() && !mp.isInOwnTerritory()) {
                        this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changingDeniedFactions")));
                        return false;
                    }
                }
                catch (NoClassDefFoundError e) {
                    FPlayers fPlayers = FPlayers.getInstance();
                    FPlayer fPlayer = fPlayers.getByPlayer(player);
                    Board board = Board.getInstance();
                    Faction blockFaction = board.getFactionAt(new FLocation(block.getLocation()));
                    if (blockFaction.isWilderness() || fPlayer.isInOwnTerritory()) break block4;
                    this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("changingDeniedFactions")));
                    return false;
                }
            }
        }
        return true;
    }
}

