/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.listeners;

import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.util.SilkUtil;
import java.util.Locale;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SilkSpawnersInventoryListener
implements Listener {
    private final SilkSpawners plugin;
    private final SilkUtil su;

    public SilkSpawnersInventoryListener(SilkSpawners instance, SilkUtil util) {
        this.plugin = instance;
        this.su = util;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPrepareItemCraftEvent(PrepareItemCraftEvent event) {
        if (event.getRecipe() == null || event.getRecipe().getResult() == null) {
            return;
        }
        if (event.getRecipe().getResult().getType() != this.su.nmsProvider.getSpawnerMaterial()) {
            return;
        }
        ItemStack result = event.getRecipe().getResult();
        for (ItemStack itemStack : event.getInventory().getContents()) {
            if (!this.su.nmsProvider.getSpawnEggMaterials().contains(itemStack.getType()) || itemStack.getDurability() != 0) continue;
            String entityID = this.su.getStoredEggEntityID(itemStack);
            result = this.su.newSpawnerItem(entityID, this.su.getCustomSpawnerName(entityID), result.getAmount(), true);
            event.getInventory().setResult(result);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onItemCraft(CraftItemEvent event) {
        if (event == null || event.getCurrentItem() == null || event.getWhoClicked() == null) {
            return;
        }
        if (event.getCurrentItem().getType() != this.su.nmsProvider.getSpawnerMaterial()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String entityID = this.su.getStoredSpawnerItemEntityID(event.getCurrentItem());
        if (entityID == null) {
            entityID = this.su.getDefaultEntityID();
        }
        String creatureName = this.su.getCreatureName(entityID);
        String spawnerName = creatureName.toLowerCase(Locale.ENGLISH).replace(" ", "");
        if (!this.su.hasPermission((Permissible)player, "silkspawners.craft.", entityID)) {
            event.setCancelled(true);
            this.su.sendMessage((CommandSender)player, ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.localization.getString("noPermissionCraft").replace("%ID%", entityID)).replace("%creature%", spawnerName));
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (event == null || event.getCurrentItem() == null || event.getWhoClicked() == null) {
            return;
        }
        if (event.getCurrentItem().getType() != this.su.nmsProvider.getSpawnerMaterial()) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String entityID = this.su.getStoredSpawnerItemEntityID(event.getCurrentItem());
        if (entityID == null) {
            entityID = this.su.getDefaultEntityID();
        }
        String creatureName = this.su.getCreatureName(entityID);
        if (this.plugin.config.getBoolean("notifyOnClick") && player.hasPermission("silkspawners.info")) {
            this.su.notify(player, creatureName);
        }
    }
}

