/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.listeners;

import de.dustplanet.silkspawners.SilkSpawners;
import de.dustplanet.silkspawners.events.SilkSpawnersSpawnerExplodeEvent;
import de.dustplanet.util.SilkUtil;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;

public class SilkSpawnersEntityListener
implements Listener {
    private final SilkSpawners plugin;
    private final SilkUtil su;
    private final Random rnd;

    public SilkSpawnersEntityListener(SilkSpawners instance, SilkUtil util) {
        this.plugin = instance;
        this.su = util;
        this.rnd = new Random();
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntiyExplode(EntityExplodeEvent event) {
        Entity entity = event.getEntity();
        if (event.getEntity() == null || entity instanceof EnderDragon || this.plugin.config.getInt("explosionDropChance", 30) == 0) {
            return;
        }
        Player sourcePlayer = null;
        if (this.plugin.config.getBoolean("permissionExplode", false) && entity instanceof TNTPrimed) {
            this.plugin.getLogger().fine("Checking for explosion permissing because igniter was TNT");
            Entity igniter = ((TNTPrimed)entity).getSource();
            if (igniter != null && igniter instanceof Player) {
                sourcePlayer = (Player)igniter;
                this.plugin.getLogger().log(Level.FINE, "Player has destroydrop permission {0}", sourcePlayer.hasPermission("silkspawners.explodedrop"));
                if (!sourcePlayer.hasPermission("silkspawners.explodedrop")) {
                    return;
                }
            }
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            Block block = (Block)iterator.next();
            if (block.getType() != this.su.nmsProvider.getSpawnerMaterial()) continue;
            this.plugin.getLogger().log(Level.FINE, "Calculating exploded spawner at {0}, {1}, {2}", new Object[]{block.getX(), block.getY(), block.getZ()});
            int randomNumber = this.rnd.nextInt(100);
            String entityID = this.su.getSpawnerEntityID(block);
            this.plugin.getLogger().log(Level.FINE, "Current entityID is {0}", entityID);
            int dropChance = 0;
            dropChance = this.plugin.mobs.contains("creatures." + entityID + ".explosionDropChance") ? this.plugin.mobs.getInt("creatures." + entityID + ".explosionDropChance", 100) : this.plugin.config.getInt("explosionDropChance", 100);
            this.plugin.getLogger().log(Level.FINE, "Current drop chance is {0}", dropChance);
            SilkSpawnersSpawnerExplodeEvent explodeEvent = new SilkSpawnersSpawnerExplodeEvent(sourcePlayer, block, entityID, dropChance);
            this.plugin.getServer().getPluginManager().callEvent((Event)explodeEvent);
            if (explodeEvent.isAllCancelled()) {
                this.plugin.getLogger().fine("Skipping entity explode event because the the SilkSpawnersSpawnerExplodeEvent has all cancelled");
                event.setCancelled(true);
                return;
            }
            if (explodeEvent.isCancelled()) {
                this.plugin.getLogger().fine("Skipping block destruction and drops because the the SilkSpawnersSpawnerExplodeEvent was cancelled");
                iterator.remove();
                continue;
            }
            entityID = explodeEvent.getEntityID();
            this.plugin.getLogger().log(Level.FINE, "New entityID is {0}", entityID);
            dropChance = explodeEvent.getDropChance();
            this.plugin.getLogger().log(Level.FINE, "New drop chance is {0}", dropChance);
            if (randomNumber >= dropChance) continue;
            ItemStack explodeEventDrop = explodeEvent.getDrop();
            ItemStack drops = null;
            if (explodeEventDrop != null) {
                this.plugin.getLogger().log(Level.FINE, "Setting custom drop: {0}x, {1}", new Object[]{explodeEventDrop.getAmount(), explodeEventDrop.getType()});
                drops = explodeEventDrop;
            } else {
                drops = this.su.newSpawnerItem(entityID, this.su.getCustomSpawnerName(entityID), 1, false);
            }
            if (drops == null) continue;
            World world = block.getWorld();
            world.dropItemNaturally(block.getLocation(), drops);
        }
    }
}

