/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.v1_9_R1;

import com.google.common.base.CaseFormat;
import com.mojang.authlib.GameProfile;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.v1_9_R1.Entity;
import net.minecraft.server.v1_9_R1.EntityPlayer;
import net.minecraft.server.v1_9_R1.EntityTypes;
import net.minecraft.server.v1_9_R1.Item;
import net.minecraft.server.v1_9_R1.ItemStack;
import net.minecraft.server.v1_9_R1.MinecraftServer;
import net.minecraft.server.v1_9_R1.NBTBase;
import net.minecraft.server.v1_9_R1.NBTTagCompound;
import net.minecraft.server.v1_9_R1.NBTTagList;
import net.minecraft.server.v1_9_R1.Packet;
import net.minecraft.server.v1_9_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_9_R1.PlayerInteractManager;
import net.minecraft.server.v1_9_R1.TileEntityMobSpawner;
import net.minecraft.server.v1_9_R1.World;
import net.minecraft.server.v1_9_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.craftbukkit.v1_9_R1.CraftServer;
import org.bukkit.craftbukkit.v1_9_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_9_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_9_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class NMSHandler
implements NMSProvider {
    private Field tileField;
    private final SortedMap<Integer, String> sortedMap = new TreeMap<Integer, String>();

    public NMSHandler() {
        try {
            this.tileField = CraftCreatureSpawner.class.getDeclaredField("spawner");
            this.tileField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void spawnEntity(org.bukkit.World w, String entityID, double x, double y, double z, Player player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("id", entityID);
        WorldServer world = ((CraftWorld)w).getHandle();
        Entity entity = EntityTypes.a((NBTTagCompound)tag, (World)world);
        if (entity == null) {
            Bukkit.getLogger().warning("[SilkSpawners] Failed to spawn, falling through. You should report this (entity == null)!");
            return;
        }
        float yaw = world.random.nextFloat() * -360.0f + 180.0f;
        entity.setPositionRotation(x, y, z, yaw, 0.0f);
        world.addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation(entity, (byte)yaw);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)rotation);
    }

    @Override
    public SortedMap<Integer, String> legacyRawEntityMap() {
        try {
            Field field = EntityTypes.class.getDeclaredField("g");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            for (Map.Entry entry : map.entrySet()) {
                this.sortedMap.put((Integer)entry.getValue(), (String)entry.getKey());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().severe("[SilkSpawners] Failed to dump entity map: " + e.getMessage());
            e.printStackTrace();
        }
        return this.sortedMap;
    }

    @Override
    public String getMobNameOfSpawner(BlockState blockState) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            return tile.getSpawner().getMobName();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSpawnersUnstackable() {
        Item.getById((int)52).d(1);
    }

    @Override
    public boolean setMobNameOfSpawner(BlockState blockState, String mobID) {
        String safeMobID = this.caseFormatOf(mobID.replace(" ", "_")).to(CaseFormat.UPPER_CAMEL, mobID.replace(" ", "_"));
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            tile.getSpawner().setMobName(safeMobID);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack setNBTEntityID(org.bukkit.inventory.ItemStack item, String entity) {
        if (item == null || entity == null || entity.isEmpty()) {
            Bukkit.getLogger().warning("[SilkSpawners] Skipping invalid spawner to set NBT data on.");
            return null;
        }
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entity);
        if (!tag.hasKey("BlockEntityTag")) {
            tag.set("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("BlockEntityTag").setString("EntityId", entity);
        if (!tag.hasKey("SpawnData")) {
            tag.set("SpawnData", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SpawnData").setString("id", entity);
        if (!tag.getCompound("BlockEntityTag").hasKey("SpawnData")) {
            tag.getCompound("BlockEntityTag").set("SpawnData", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("BlockEntityTag").getCompound("SpawnData").setString("id", entity);
        if (!tag.getCompound("BlockEntityTag").hasKey("SpawnPotentials")) {
            tag.getCompound("BlockEntityTag").set("SpawnPotentials", (NBTBase)new NBTTagCompound());
        }
        NBTTagList tagList = new NBTTagList();
        NBTTagCompound spawnPotentials = new NBTTagCompound();
        spawnPotentials.set("Entity", (NBTBase)new NBTTagCompound());
        spawnPotentials.getCompound("Entity").setString("id", entity);
        spawnPotentials.setInt("Weight", 1);
        tagList.add((NBTBase)spawnPotentials);
        tag.getCompound("BlockEntityTag").set("SpawnPotentials", (NBTBase)tagList);
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("EntityTag").setString("id", entity);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    @Nullable
    public String getSilkSpawnersNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("SilkSpawners")) {
            return null;
        }
        NBTTagCompound silkSpawnersTag = tag.getCompound("SilkSpawners");
        if (silkSpawnersTag.hasKey("entity")) {
            return silkSpawnersTag.getString("entity");
        }
        if (silkSpawnersTag.hasKey("entityID")) {
            return this.getEntityFromNumericalID(silkSpawnersTag.getShort("entityID"));
        }
        return null;
    }

    @Override
    @Nullable
    public String getVanillaNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("BlockEntityTag")) {
            return null;
        }
        if ((tag = tag.getCompound("BlockEntityTag")).hasKey("EntityId")) {
            return tag.getString("EntityId");
        }
        if (tag.hasKey("SpawnData") && tag.getCompound("SpawnData").hasKey("id")) {
            return tag.getCompound("SpawnData").getString("id");
        }
        if (tag.hasKey("SpawnPotentials") && !tag.getList("SpawnPotentials", 8).isEmpty()) {
            return tag.getList("SpawnPotentials", 8).get(0).getCompound("Entity").getString("id");
        }
        return null;
    }

    @Override
    public Block getSpawnerFacing(Player player, int distance) {
        Block block = player.getTargetBlock((Set)null, distance);
        if (block == null || block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        return block;
    }

    @Override
    public org.bukkit.inventory.ItemStack newEggItem(String entityID, int amount, String displayName) {
        org.bukkit.inventory.ItemStack item = new org.bukkit.inventory.ItemStack(Material.MONSTER_EGG, amount);
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entityID);
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("EntityTag").setString("id", entityID);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    public String getVanillaEggNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("EntityTag")) {
            return null;
        }
        if ((tag = tag.getCompound("EntityTag")).hasKey("id")) {
            return tag.getString("id");
        }
        return null;
    }

    @Override
    public void displayBossBar(String title, String colorName, String styleName, Player player, Plugin plugin, int period) {
        BarColor color = BarColor.valueOf((String)colorName.toUpperCase());
        BarStyle style = BarStyle.valueOf((String)styleName.toUpperCase());
        final BossBar bar = Bukkit.createBossBar((String)title, (BarColor)color, (BarStyle)style, (BarFlag[])new BarFlag[0]);
        bar.addPlayer(player);
        bar.setVisible(true);
        final double interval = 1.0 / (double)((long)period * 20L);
        new BukkitRunnable(){

            public void run() {
                double progress = bar.getProgress();
                double newProgress = progress - interval;
                if (progress <= 0.0 || newProgress <= 0.0) {
                    bar.setVisible(false);
                    bar.removeAll();
                    this.cancel();
                } else {
                    bar.setProgress(newProgress);
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 1L);
    }

    @Override
    public Player getPlayer(String playerUUIDOrName) {
        try {
            UUID playerUUID = UUID.fromString(playerUUIDOrName);
            return Bukkit.getPlayer((UUID)playerUUID);
        }
        catch (IllegalArgumentException e) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.getName().equalsIgnoreCase(playerUUIDOrName)) continue;
                return onlinePlayer;
            }
            return null;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemInHand(Player player) {
        return player.getInventory().getItemInMainHand();
    }

    @Override
    public void reduceEggs(Player player) {
        org.bukkit.inventory.ItemStack itemInMainHand = player.getInventory().getItemInMainHand();
        org.bukkit.inventory.ItemStack itemInOffHand = player.getInventory().getItemInOffHand();
        if (itemInMainHand.getType() == Material.MONSTER_EGG) {
            org.bukkit.inventory.ItemStack eggs = itemInMainHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInMainHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInMainHand(eggs);
            }
        } else {
            org.bukkit.inventory.ItemStack eggs = itemInOffHand;
            if (eggs.getAmount() == 1) {
                player.getInventory().setItemInOffHand(null);
            } else {
                eggs.setAmount(eggs.getAmount() - 1);
                player.getInventory().setItemInOffHand(eggs);
            }
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getSpawnerItemInHand(Player player) {
        PlayerInventory inv = player.getInventory();
        org.bukkit.inventory.ItemStack mainHand = inv.getItemInMainHand();
        org.bukkit.inventory.ItemStack offHand = inv.getItemInOffHand();
        if (!(mainHand.getType() != Material.MONSTER_EGG && mainHand.getType() != Material.MOB_SPAWNER || offHand.getType() != Material.MONSTER_EGG && offHand.getType() != Material.MOB_SPAWNER)) {
            return null;
        }
        if (mainHand.getType() == Material.MONSTER_EGG || mainHand.getType() == Material.MOB_SPAWNER) {
            return mainHand;
        }
        if (offHand.getType() == Material.MONSTER_EGG || offHand.getType() == Material.MOB_SPAWNER) {
            return offHand;
        }
        return null;
    }

    @Override
    public void setSpawnerItemInHand(Player player, org.bukkit.inventory.ItemStack newItem) {
        PlayerInventory inv = player.getInventory();
        org.bukkit.inventory.ItemStack mainHand = inv.getItemInMainHand();
        org.bukkit.inventory.ItemStack offHand = inv.getItemInOffHand();
        if (!(mainHand.getType() != Material.MONSTER_EGG && mainHand.getType() != Material.MOB_SPAWNER || offHand.getType() != Material.MONSTER_EGG && offHand.getType() != Material.MOB_SPAWNER)) {
            return;
        }
        if (mainHand.getType() == Material.MONSTER_EGG || mainHand.getType() == Material.MOB_SPAWNER) {
            inv.setItemInMainHand(newItem);
        } else if (offHand.getType() == Material.MONSTER_EGG || offHand.getType() == Material.MOB_SPAWNER) {
            inv.setItemInOffHand(newItem);
        }
    }

    @Override
    public Collection<Material> getSpawnEggMaterials() {
        return Collections.singleton(Material.MONSTER_EGG);
    }

    @Override
    public Material getSpawnerMaterial() {
        return Material.MOB_SPAWNER;
    }

    @Override
    public Material getIronFenceMaterial() {
        return Material.IRON_FENCE;
    }

    @Override
    public Player loadPlayer(OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer(server, server.getWorldServer(0), profile, new PlayerInteractManager((World)server.getWorldServer(0)));
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }

    @Nullable
    private String getEntityFromNumericalID(int numericalEntityID) {
        return (String)this.sortedMap.get(numericalEntityID);
    }
}

