/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.v1_8_R2;

import com.google.common.base.CaseFormat;
import com.mojang.authlib.GameProfile;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R2.Entity;
import net.minecraft.server.v1_8_R2.EntityPlayer;
import net.minecraft.server.v1_8_R2.EntityTypes;
import net.minecraft.server.v1_8_R2.Item;
import net.minecraft.server.v1_8_R2.ItemStack;
import net.minecraft.server.v1_8_R2.MinecraftServer;
import net.minecraft.server.v1_8_R2.NBTBase;
import net.minecraft.server.v1_8_R2.NBTTagCompound;
import net.minecraft.server.v1_8_R2.Packet;
import net.minecraft.server.v1_8_R2.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R2.PlayerInteractManager;
import net.minecraft.server.v1_8_R2.TileEntityMobSpawner;
import net.minecraft.server.v1_8_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_8_R2.CraftServer;
import org.bukkit.craftbukkit.v1_8_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R2.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R2.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class NMSHandler
implements NMSProvider {
    private Field tileField;
    private final SortedMap<String, Integer> entitiesMaps = new TreeMap<String, Integer>();

    public NMSHandler() {
        try {
            this.tileField = CraftCreatureSpawner.class.getDeclaredField("spawner");
            this.tileField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void spawnEntity(World w, String entityID, double x, double y, double z, Player player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("id", entityID);
        WorldServer world = ((CraftWorld)w).getHandle();
        Entity entity = EntityTypes.a((NBTTagCompound)tag, (net.minecraft.server.v1_8_R2.World)world);
        if (entity == null) {
            Bukkit.getLogger().warning("[SilkSpawners] Failed to spawn, falling through. You should report this (entity == null)!");
            return;
        }
        float yaw = world.random.nextFloat() * -360.0f + 180.0f;
        entity.setPositionRotation(x, y, z, yaw, 0.0f);
        world.addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation(entity, (byte)yaw);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)rotation);
    }

    @Override
    public SortedMap<Integer, String> legacyRawEntityMap() {
        TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
        try {
            Field field = EntityTypes.class.getDeclaredField("g");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            for (Map.Entry entry : map.entrySet()) {
                sortedMap.put((Integer)entry.getValue(), (String)entry.getKey());
                this.entitiesMaps.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().severe("[SilkSpawners] Failed to dump entity map: " + e.getMessage());
            e.printStackTrace();
        }
        return sortedMap;
    }

    @Override
    public String getMobNameOfSpawner(BlockState blockState) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            return tile.getSpawner().getMobName();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSpawnersUnstackable() {
        Item.getById((int)52).c(1);
    }

    @Override
    public boolean setMobNameOfSpawner(BlockState blockState, String mobID) {
        String safeMobID = this.caseFormatOf(mobID.replace(" ", "_")).to(CaseFormat.UPPER_CAMEL, mobID.replace(" ", "_"));
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            tile.getSpawner().setMobName(safeMobID);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack setNBTEntityID(org.bukkit.inventory.ItemStack item, String entity) {
        if (item == null || entity == null || entity.isEmpty()) {
            Bukkit.getLogger().warning("[SilkSpawners] Skipping invalid spawner to set NBT data on.");
            return null;
        }
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entity);
        if (!tag.hasKey("BlockEntityTag")) {
            tag.set("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("BlockEntityTag").setString("EntityId", entity);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    @Nullable
    public String getSilkSpawnersNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("SilkSpawners")) {
            return null;
        }
        NBTTagCompound silkSpawnersTag = tag.getCompound("SilkSpawners");
        if (silkSpawnersTag.hasKey("entity")) {
            return silkSpawnersTag.getString("entity");
        }
        if (silkSpawnersTag.hasKey("entityID")) {
            return this.getEntityFromNumericalID(silkSpawnersTag.getShort("entityID"));
        }
        return null;
    }

    @Override
    public String getVanillaNBTEntityID(org.bukkit.inventory.ItemStack item) {
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("BlockEntityTag")) {
            return null;
        }
        return tag.getCompound("BlockEntityTag").getString("EntityId");
    }

    @Override
    public Block getSpawnerFacing(Player player, int distance) {
        Block block = player.getTargetBlock((Set)null, distance);
        if (block == null || block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        return block;
    }

    @Override
    public org.bukkit.inventory.ItemStack newEggItem(String entityID, int amount, String displayName) {
        org.bukkit.inventory.ItemStack item = new org.bukkit.inventory.ItemStack(Material.MONSTER_EGG, amount, ((Integer)this.entitiesMaps.get(entityID)).shortValue());
        ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((org.bukkit.inventory.ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entityID);
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("EntityTag").setString("id", entityID);
        return CraftItemStack.asCraftMirror((ItemStack)itemStack);
    }

    @Override
    public Player getPlayer(String playerUUIDOrName) {
        try {
            UUID playerUUID = UUID.fromString(playerUUIDOrName);
            return Bukkit.getPlayer((UUID)playerUUID);
        }
        catch (IllegalArgumentException e) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.getName().equalsIgnoreCase(playerUUIDOrName)) continue;
                return onlinePlayer;
            }
            return null;
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getItemInHand(Player player) {
        return player.getItemInHand();
    }

    @Override
    public void reduceEggs(Player player) {
        org.bukkit.inventory.ItemStack eggs = player.getItemInHand();
        if (eggs.getAmount() == 1) {
            player.setItemInHand(null);
        } else {
            eggs.setAmount(eggs.getAmount() - 1);
            player.setItemInHand(eggs);
        }
    }

    @Override
    public org.bukkit.inventory.ItemStack getSpawnerItemInHand(Player player) {
        return player.getItemInHand();
    }

    @Override
    public void setSpawnerItemInHand(Player player, org.bukkit.inventory.ItemStack newItem) {
        player.setItemInHand(newItem);
    }

    @Override
    public Collection<Material> getSpawnEggMaterials() {
        return Collections.singleton(Material.MONSTER_EGG);
    }

    @Override
    public int getIDForEntity(String entityID) {
        return (Integer)this.entitiesMaps.get(entityID);
    }

    @Override
    public Material getSpawnerMaterial() {
        return Material.MOB_SPAWNER;
    }

    @Override
    public Material getIronFenceMaterial() {
        return Material.IRON_FENCE;
    }

    @Override
    public Player loadPlayer(OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer(server, server.getWorldServer(0), profile, new PlayerInteractManager((net.minecraft.server.v1_8_R2.World)server.getWorldServer(0)));
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }

    @Override
    public String getVanillaEggNBTEntityID(org.bukkit.inventory.ItemStack item) {
        short numericalEntityID = item.getDurability();
        return this.getEntityFromNumericalID(numericalEntityID);
    }

    @Nullable
    private String getEntityFromNumericalID(short numericalEntityID) {
        Optional<String> mobEntry = this.entitiesMaps.entrySet().stream().filter(entry -> (Integer)entry.getValue() == numericalEntityID).findFirst().map(Map.Entry::getKey);
        return mobEntry.orElse(null);
    }
}

