/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.v1_8_R1;

import com.google.common.base.CaseFormat;
import com.mojang.authlib.GameProfile;
import de.dustplanet.silkspawners.compat.api.NMSProvider;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R1.Entity;
import net.minecraft.server.v1_8_R1.EntityPlayer;
import net.minecraft.server.v1_8_R1.EntityTypes;
import net.minecraft.server.v1_8_R1.Item;
import net.minecraft.server.v1_8_R1.MinecraftServer;
import net.minecraft.server.v1_8_R1.NBTBase;
import net.minecraft.server.v1_8_R1.NBTTagCompound;
import net.minecraft.server.v1_8_R1.Packet;
import net.minecraft.server.v1_8_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_8_R1.PlayerInteractManager;
import net.minecraft.server.v1_8_R1.TileEntityMobSpawner;
import net.minecraft.server.v1_8_R1.World;
import net.minecraft.server.v1_8_R1.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_8_R1.CraftServer;
import org.bukkit.craftbukkit.v1_8_R1.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R1.block.CraftCreatureSpawner;
import org.bukkit.craftbukkit.v1_8_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_8_R1.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;

public class NMSHandler
implements NMSProvider {
    private Field tileField;
    private final SortedMap<String, Integer> entitiesMaps = new TreeMap<String, Integer>();

    public NMSHandler() {
        try {
            this.tileField = CraftCreatureSpawner.class.getDeclaredField("spawner");
            this.tileField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void spawnEntity(org.bukkit.World w, String entityID, double x, double y, double z, Player player) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setString("id", entityID);
        WorldServer world = ((CraftWorld)w).getHandle();
        Entity entity = EntityTypes.a((NBTTagCompound)tag, (World)world);
        if (entity == null) {
            Bukkit.getLogger().warning("[SilkSpawners] Failed to spawn, falling through. You should report this (entity == null)!");
            return;
        }
        float yaw = world.random.nextFloat() * -360.0f + 180.0f;
        entity.setPositionRotation(x, y, z, yaw, 0.0f);
        world.addEntity(entity, CreatureSpawnEvent.SpawnReason.SPAWNER_EGG);
        PacketPlayOutEntityHeadRotation rotation = new PacketPlayOutEntityHeadRotation(entity, (byte)yaw);
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)rotation);
    }

    @Override
    public SortedMap<Integer, String> legacyRawEntityMap() {
        TreeMap<Integer, String> sortedMap = new TreeMap<Integer, String>();
        try {
            Field field = EntityTypes.class.getDeclaredField("g");
            field.setAccessible(true);
            Map map = (Map)field.get(null);
            for (Map.Entry entry : map.entrySet()) {
                sortedMap.put((Integer)entry.getValue(), (String)entry.getKey());
                this.entitiesMaps.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Bukkit.getLogger().severe("[SilkSpawners] Failed to dump entity map: " + e.getMessage());
            e.printStackTrace();
        }
        return sortedMap;
    }

    @Override
    public String getMobNameOfSpawner(BlockState blockState) {
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            return tile.getSpawner().getMobName();
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void setSpawnersUnstackable() {
        Item.getById((int)52).c(1);
    }

    @Override
    public boolean setMobNameOfSpawner(BlockState blockState, String mobID) {
        String safeMobID = this.caseFormatOf(mobID.replace(" ", "_")).to(CaseFormat.UPPER_CAMEL, mobID.replace(" ", "_"));
        CraftCreatureSpawner spawner = (CraftCreatureSpawner)blockState;
        try {
            TileEntityMobSpawner tile = (TileEntityMobSpawner)this.tileField.get(spawner);
            tile.getSpawner().setMobName(safeMobID);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Bukkit.getLogger().warning("[SilkSpawners] Reflection failed: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ItemStack setNBTEntityID(ItemStack item, String entity) {
        if (item == null || entity == null || entity.isEmpty()) {
            Bukkit.getLogger().warning("[SilkSpawners] Skipping invalid spawner to set NBT data on.");
            return null;
        }
        net.minecraft.server.v1_8_R1.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entity);
        if (!tag.hasKey("BlockEntityTag")) {
            tag.set("BlockEntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("BlockEntityTag").setString("EntityId", entity);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R1.ItemStack)itemStack);
    }

    @Override
    @Nullable
    public String getSilkSpawnersNBTEntityID(ItemStack item) {
        net.minecraft.server.v1_8_R1.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("SilkSpawners")) {
            return null;
        }
        NBTTagCompound silkSpawnersTag = tag.getCompound("SilkSpawners");
        if (silkSpawnersTag.hasKey("entity")) {
            return silkSpawnersTag.getString("entity");
        }
        if (silkSpawnersTag.hasKey("entityID")) {
            return this.getEntityFromNumericalID(silkSpawnersTag.getShort("entityID"));
        }
        return null;
    }

    @Override
    @Nullable
    public String getVanillaNBTEntityID(ItemStack item) {
        net.minecraft.server.v1_8_R1.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null || !tag.hasKey("BlockEntityTag")) {
            return null;
        }
        return tag.getCompound("BlockEntityTag").getString("EntityId");
    }

    @Override
    public Block getSpawnerFacing(Player player, int distance) {
        Block block = null;
        try {
            block = player.getTargetBlock((Set)null, distance);
        }
        catch (NoSuchMethodError e) {
            block = player.getTargetBlock((HashSet)null, distance);
        }
        if (block == null || block.getType() != Material.MOB_SPAWNER) {
            return null;
        }
        return block;
    }

    @Override
    public ItemStack newEggItem(String entityID, int amount, String displayName) {
        ItemStack item = new ItemStack(Material.MONSTER_EGG, amount, ((Integer)this.entitiesMaps.get(entityID)).shortValue());
        net.minecraft.server.v1_8_R1.ItemStack itemStack = null;
        CraftItemStack craftStack = CraftItemStack.asCraftCopy((ItemStack)item);
        itemStack = CraftItemStack.asNMSCopy((ItemStack)craftStack);
        NBTTagCompound tag = itemStack.getTag();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.setTag(tag);
        }
        if (!tag.hasKey("SilkSpawners")) {
            tag.set("SilkSpawners", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("SilkSpawners").setString("entity", entityID);
        if (!tag.hasKey("EntityTag")) {
            tag.set("EntityTag", (NBTBase)new NBTTagCompound());
        }
        tag.getCompound("EntityTag").setString("id", entityID);
        return CraftItemStack.asCraftMirror((net.minecraft.server.v1_8_R1.ItemStack)itemStack);
    }

    @Override
    public Player getPlayer(String playerUUIDOrName) {
        try {
            UUID playerUUID = UUID.fromString(playerUUIDOrName);
            return Bukkit.getPlayer((UUID)playerUUID);
        }
        catch (IllegalArgumentException e) {
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                if (!onlinePlayer.getName().equalsIgnoreCase(playerUUIDOrName)) continue;
                return onlinePlayer;
            }
            return null;
        }
    }

    @Override
    public ItemStack getItemInHand(Player player) {
        return player.getItemInHand();
    }

    @Override
    public void reduceEggs(Player player) {
        ItemStack eggs = player.getItemInHand();
        if (eggs.getAmount() == 1) {
            player.setItemInHand(null);
        } else {
            eggs.setAmount(eggs.getAmount() - 1);
            player.setItemInHand(eggs);
        }
    }

    @Override
    public ItemStack getSpawnerItemInHand(Player player) {
        return player.getItemInHand();
    }

    @Override
    public void setSpawnerItemInHand(Player player, ItemStack newItem) {
        player.setItemInHand(newItem);
    }

    @Override
    public Collection<Material> getSpawnEggMaterials() {
        return Collections.singleton(Material.MONSTER_EGG);
    }

    @Override
    public int getIDForEntity(String entityID) {
        return (Integer)this.entitiesMaps.get(entityID);
    }

    @Override
    public Material getSpawnerMaterial() {
        return Material.MOB_SPAWNER;
    }

    @Override
    public Material getIronFenceMaterial() {
        return Material.IRON_FENCE;
    }

    @Override
    public Player loadPlayer(OfflinePlayer offline) {
        if (!offline.hasPlayedBefore()) {
            return null;
        }
        GameProfile profile = new GameProfile(offline.getUniqueId(), offline.getName() != null ? offline.getName() : offline.getUniqueId().toString());
        MinecraftServer server = ((CraftServer)Bukkit.getServer()).getServer();
        EntityPlayer entity = new EntityPlayer(server, server.getWorldServer(0), profile, new PlayerInteractManager((World)server.getWorldServer(0)));
        CraftPlayer target = entity.getBukkitEntity();
        if (target != null) {
            target.loadData();
        }
        return target;
    }

    @Override
    public String getVanillaEggNBTEntityID(ItemStack item) {
        short numericalEntityID = item.getDurability();
        return this.getEntityFromNumericalID(numericalEntityID);
    }

    @Nullable
    private String getEntityFromNumericalID(short numericalEntityID) {
        Optional<String> mobEntry = this.entitiesMaps.entrySet().stream().filter(entry -> (Integer)entry.getValue() == numericalEntityID).findFirst().map(Map.Entry::getKey);
        return mobEntry.orElse(null);
    }
}

