/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.compat.api;

import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.List;
import java.util.SortedMap;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public interface NMSProvider {
    public static final Pattern LOWER_CAMEL_REGEX = Pattern.compile("([a-z]+[A-Z]+\\w+)+");
    public static final Pattern UPPER_CAMEL_REGEX = Pattern.compile("([A-Z]+[a-z]+\\w+)+");
    public static final int SPAWNER_ID = 52;
    public static final String NAMESPACED_SPAWNER_ID = "spawner";

    public void spawnEntity(World var1, String var2, double var3, double var5, double var7, Player var9);

    default public List<String> rawEntityMap() {
        return null;
    }

    default public SortedMap<Integer, String> legacyRawEntityMap() {
        return null;
    }

    public String getMobNameOfSpawner(BlockState var1);

    public boolean setMobNameOfSpawner(BlockState var1, String var2);

    public void setSpawnersUnstackable();

    public ItemStack setNBTEntityID(ItemStack var1, String var2);

    public String getSilkSpawnersNBTEntityID(ItemStack var1);

    public String getVanillaNBTEntityID(ItemStack var1);

    public Block getSpawnerFacing(Player var1, int var2);

    default public Collection<? extends Player> getOnlinePlayers() {
        return Bukkit.getOnlinePlayers();
    }

    @Deprecated
    default public ItemStack newEggItem(String entityID, int amount) {
        return this.newEggItem(entityID, amount, null);
    }

    public ItemStack newEggItem(String var1, int var2, String var3);

    public String getVanillaEggNBTEntityID(ItemStack var1);

    default public void displayBossBar(String title, String colorName, String styleName, Player player, Plugin plugin, int period) {
    }

    public ItemStack getItemInHand(Player var1);

    public ItemStack getSpawnerItemInHand(Player var1);

    public void setSpawnerItemInHand(Player var1, ItemStack var2);

    public void reduceEggs(Player var1);

    public Player getPlayer(String var1);

    default public Material getSpawnerMaterial() {
        return Material.SPAWNER;
    }

    default public Material getIronFenceMaterial() {
        return Material.IRON_BARS;
    }

    @Deprecated
    default public Material getSpawnEggMaterial() {
        Collection<Material> spawnEggs = this.getSpawnEggMaterials();
        if (spawnEggs.size() > 1) {
            throw new UnsupportedOperationException("Spawn egg is not determinable because there is more than one material, please use getSpawnEggMaterials() for v1.13+");
        }
        return spawnEggs.iterator().next();
    }

    public Collection<Material> getSpawnEggMaterials();

    default public int getIDForEntity(String entityID) {
        return 0;
    }

    default public CaseFormat caseFormatOf(String s) {
        if (s.contains("_")) {
            if (s.toUpperCase().equals(s)) {
                return CaseFormat.UPPER_UNDERSCORE;
            }
            if (s.toLowerCase().equals(s)) {
                return CaseFormat.LOWER_UNDERSCORE;
            }
        } else if (s.contains("-")) {
            if (s.toLowerCase().equals(s)) {
                return CaseFormat.LOWER_HYPHEN;
            }
        } else if (Character.isLowerCase(s.charAt(0))) {
            if (LOWER_CAMEL_REGEX.matcher(s).matches()) {
                return CaseFormat.LOWER_CAMEL;
            }
        } else if (UPPER_CAMEL_REGEX.matcher(s).matches()) {
            return CaseFormat.UPPER_CAMEL;
        }
        return CaseFormat.LOWER_UNDERSCORE;
    }

    public Player loadPlayer(OfflinePlayer var1);
}

