/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.silkspawners.commands;

import de.dustplanet.util.SilkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SilkSpawnersTabCompleter
implements TabCompleter {
    private final String[] commands = new String[]{"add", "all", "change", "give", "help", "list", "reload", "rl", "set", "view", "info"};
    private final SilkUtil su;

    public SilkSpawnersTabCompleter(SilkUtil util) {
        this.su = util;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length == 1) {
            String command = args[0].toLowerCase(Locale.ENGLISH);
            return this.addCommands(command);
        }
        if (args.length == 2 && ("change".equalsIgnoreCase(args[0]) || "set".equalsIgnoreCase(args[0]))) {
            String mob = args[1].toLowerCase(Locale.ENGLISH);
            results.addAll(this.addMobs(mob));
        } else if (args.length == 2 && ("give".equalsIgnoreCase(args[0]) || "add".equalsIgnoreCase(args[0]))) {
            String player = args[1].toLowerCase(Locale.ENGLISH);
            results.addAll(this.addPlayers(player));
        } else if (args.length == 3 && ("give".equalsIgnoreCase(args[0]) || "add".equalsIgnoreCase(args[0]))) {
            String mob = args[2].toLowerCase(Locale.ENGLISH);
            results.addAll(this.addMobs(mob));
        } else if (args.length == 2 && ("selfget".equalsIgnoreCase(args[0]) || "i".equalsIgnoreCase(args[0]))) {
            String mob = args[1].toLowerCase(Locale.ENGLISH);
            results.addAll(this.addMobs(mob));
        }
        return results;
    }

    private ArrayList<String> addCommands(String cmd) {
        ArrayList<String> results = new ArrayList<String>();
        for (String command : this.commands) {
            if (!command.startsWith(cmd)) continue;
            results.add(command);
        }
        return results;
    }

    private ArrayList<String> addMobs(String mob) {
        ArrayList<String> results = new ArrayList<String>();
        for (String displayName : this.su.getDisplayNameToMobID().keySet()) {
            if (!(displayName = displayName.toLowerCase(Locale.ENGLISH).replace(" ", "")).startsWith(mob)) continue;
            results.add(displayName);
        }
        return results;
    }

    private ArrayList<String> addPlayers(String playerString) {
        ArrayList<String> results = new ArrayList<String>();
        for (Player player : this.su.nmsProvider.getOnlinePlayers()) {
            String displayName = player.getName().toLowerCase(Locale.ENGLISH).replace(" ", "");
            if (!displayName.startsWith(playerString)) continue;
            results.add(player.getName());
        }
        return results;
    }
}

