/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.util;

import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Util {
    private Util() {
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    private static Map<String, String> parseCsv(String string, String string2) {
        if (Util.isNullOrEmpty(string)) {
            return Collections.emptyMap();
        }
        String[] stringArray = string.split(",");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (String string3 : stringArray) {
            String[] stringArray2 = string3.split(":");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException("Invalid " + string2 + " entry: " + string3);
            }
            linkedHashMap.put(stringArray2[0], stringArray2[1]);
        }
        return linkedHashMap;
    }

    public static Map<String, String> parseTags(String string) {
        return Util.parseCsv(string, "tags");
    }

    public static Map<String, String> parseExtra(String string) {
        return Util.parseCsv(string, "extras");
    }

    @Deprecated
    public static Set<String> parseExtraTags(String string) {
        return Util.parseMdcTags(string);
    }

    public static Set<String> parseMdcTags(String string) {
        if (Util.isNullOrEmpty(string)) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(string.split(",")));
    }

    public static Integer parseInteger(String string, Integer n) {
        if (Util.isNullOrEmpty(string)) {
            return n;
        }
        return Integer.parseInt(string);
    }

    public static Long parseLong(String string, Long l) {
        if (Util.isNullOrEmpty(string)) {
            return l;
        }
        return Long.parseLong(string);
    }

    public static Double parseDouble(String string, Double d) {
        if (Util.isNullOrEmpty(string)) {
            return d;
        }
        return Double.parseDouble(string);
    }

    public static String trimString(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n - 3) + "...";
        }
        return string;
    }

    public static boolean safelyRemoveShutdownHook(Thread thread) {
        try {
            return Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (IllegalStateException illegalStateException) {
            if (!illegalStateException.getMessage().equals("Shutdown in progress")) {
                throw illegalStateException;
            }
            return false;
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

