/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.util;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

public class CircularFifoQueue<E>
extends AbstractCollection<E>
implements Queue<E>,
Serializable {
    private static final long serialVersionUID = -8423413834657610406L;
    private transient E[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public CircularFifoQueue() {
        this(32);
    }

    public CircularFifoQueue(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[n];
        this.maxElements = this.elements.length;
    }

    public CircularFifoQueue(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        for (E e : this) {
            objectOutputStream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.elements = new Object[this.maxElements];
        int n = objectInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            this.elements[i] = objectInputStream.readObject();
        }
        this.start = 0;
        this.full = n == this.maxElements;
        this.end = this.full ? 0 : n;
    }

    @Override
    public int size() {
        int n = 0;
        n = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return n;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFull() {
        return false;
    }

    public boolean isAtFullCapacity() {
        return this.size() == this.maxElements;
    }

    public int maxSize() {
        return this.maxElements;
    }

    @Override
    public void clear() {
        this.full = false;
        this.start = 0;
        this.end = 0;
        Arrays.fill(this.elements, null);
    }

    @Override
    public boolean add(E e) {
        if (null == e) {
            throw new NullPointerException("Attempted to add null object to queue");
        }
        if (this.isAtFullCapacity()) {
            this.remove();
        }
        this.elements[this.end++] = e;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    public E get(int n) {
        int n2 = this.size();
        if (n < 0 || n >= n2) {
            throw new NoSuchElementException(String.format("The specified index (%1$d) is outside the available range [0, %2$d)", n, n2));
        }
        int n3 = (this.start + n) % this.maxElements;
        return this.elements[n3];
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    @Override
    public E element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        return this.peek();
    }

    @Override
    public E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[this.start];
    }

    @Override
    public E remove() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        E e = this.elements[this.start];
        if (null != e) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        return e;
    }

    private int increment(int n) {
        if (++n >= this.maxElements) {
            n = 0;
        }
        return n;
    }

    private int decrement(int n) {
        if (--n < 0) {
            n = this.maxElements - 1;
        }
        return n;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            {
                this.index = CircularFifoQueue.this.start;
                this.lastReturnedIndex = -1;
                this.isFirst = CircularFifoQueue.this.full;
            }

            @Override
            public boolean hasNext() {
                return this.isFirst || this.index != CircularFifoQueue.this.end;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = CircularFifoQueue.this.increment(this.index);
                return CircularFifoQueue.this.elements[this.lastReturnedIndex];
            }

            @Override
            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == CircularFifoQueue.this.start) {
                    CircularFifoQueue.this.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int n = this.lastReturnedIndex + 1;
                if (CircularFifoQueue.this.start < this.lastReturnedIndex && n < CircularFifoQueue.this.end) {
                    System.arraycopy(CircularFifoQueue.this.elements, n, CircularFifoQueue.this.elements, this.lastReturnedIndex, CircularFifoQueue.this.end - n);
                } else {
                    while (n != CircularFifoQueue.this.end) {
                        if (n >= CircularFifoQueue.this.maxElements) {
                            ((CircularFifoQueue)CircularFifoQueue.this).elements[n - 1] = CircularFifoQueue.this.elements[0];
                            n = 0;
                            continue;
                        }
                        ((CircularFifoQueue)CircularFifoQueue.this).elements[((CircularFifoQueue)CircularFifoQueue.this).decrement((int)n)] = CircularFifoQueue.this.elements[n];
                        n = CircularFifoQueue.this.increment(n);
                    }
                }
                this.lastReturnedIndex = -1;
                CircularFifoQueue.this.end = CircularFifoQueue.this.decrement(CircularFifoQueue.this.end);
                ((CircularFifoQueue)CircularFifoQueue.this).elements[((CircularFifoQueue)CircularFifoQueue.this).end] = null;
                CircularFifoQueue.this.full = false;
                this.index = CircularFifoQueue.this.decrement(this.index);
            }
        };
    }
}

