/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryStackTraceElement;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.StackTraceInterface;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.InterfaceBinding;

public class StackTraceInterfaceBinding
implements InterfaceBinding<StackTraceInterface> {
    private static final String FRAMES_PARAMETER = "frames";
    private static final String FILENAME_PARAMETER = "filename";
    private static final String FUNCTION_PARAMETER = "function";
    private static final String MODULE_PARAMETER = "module";
    private static final String LINE_NO_PARAMETER = "lineno";
    private static final String COL_NO_PARAMETER = "colno";
    private static final String ABSOLUTE_PATH_PARAMETER = "abs_path";
    private static final String CONTEXT_LINE_PARAMETER = "context_line";
    private static final String PRE_CONTEXT_PARAMETER = "pre_context";
    private static final String POST_CONTEXT_PARAMETER = "post_context";
    private static final String IN_APP_PARAMETER = "in_app";
    private static final String VARIABLES_PARAMETER = "vars";
    private static final String PLATFORM_PARAMTER = "platform";
    private static List<Pattern> inAppBlacklistRegexps = new ArrayList<Pattern>();
    private Collection<String> inAppFrames = Collections.emptyList();
    private boolean removeCommonFramesWithEnclosing = true;

    private void writeFrame(JsonGenerator jsonGenerator, SentryStackTraceElement sentryStackTraceElement, boolean bl) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(FILENAME_PARAMETER, sentryStackTraceElement.getFileName());
        jsonGenerator.writeStringField(MODULE_PARAMETER, sentryStackTraceElement.getModule());
        boolean bl2 = (!this.removeCommonFramesWithEnclosing || !bl) && this.isFrameInApp(sentryStackTraceElement);
        jsonGenerator.writeBooleanField(IN_APP_PARAMETER, bl2);
        jsonGenerator.writeStringField(FUNCTION_PARAMETER, sentryStackTraceElement.getFunction());
        jsonGenerator.writeNumberField(LINE_NO_PARAMETER, sentryStackTraceElement.getLineno());
        if (sentryStackTraceElement.getColno() != null) {
            jsonGenerator.writeNumberField(COL_NO_PARAMETER, sentryStackTraceElement.getColno());
        }
        if (sentryStackTraceElement.getPlatform() != null) {
            jsonGenerator.writeStringField(PLATFORM_PARAMTER, sentryStackTraceElement.getPlatform());
        }
        if (sentryStackTraceElement.getAbsPath() != null) {
            jsonGenerator.writeStringField(ABSOLUTE_PATH_PARAMETER, sentryStackTraceElement.getAbsPath());
        }
        if (sentryStackTraceElement.getLocals() != null && !sentryStackTraceElement.getLocals().isEmpty()) {
            jsonGenerator.writeObjectFieldStart(VARIABLES_PARAMETER);
            for (Map.Entry<String, Object> entry : sentryStackTraceElement.getLocals().entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                jsonGenerator.writeObject(entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    private boolean isFrameInApp(SentryStackTraceElement sentryStackTraceElement) {
        for (String string : this.inAppFrames) {
            String string2 = sentryStackTraceElement.getModule();
            if (!string2.startsWith(string) || this.isBlacklistedFromInApp(string2)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlacklistedFromInApp(String string) {
        for (Pattern pattern : inAppBlacklistRegexps) {
            boolean bl = pattern.matcher(string).find();
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeInterface(JsonGenerator jsonGenerator, StackTraceInterface stackTraceInterface) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeArrayFieldStart(FRAMES_PARAMETER);
        SentryStackTraceElement[] sentryStackTraceElementArray = stackTraceInterface.getStackTrace();
        int n = stackTraceInterface.getFramesCommonWithEnclosing();
        for (int i = sentryStackTraceElementArray.length - 1; i >= 0; --i) {
            this.writeFrame(jsonGenerator, sentryStackTraceElementArray[i], n-- > 0);
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    public void setRemoveCommonFramesWithEnclosing(boolean bl) {
        this.removeCommonFramesWithEnclosing = bl;
    }

    public void setInAppFrames(Collection<String> collection) {
        this.inAppFrames = collection;
    }

    static {
        inAppBlacklistRegexps.add(Pattern.compile("\\$\\$FastClass[a-zA-Z]*CGLIB\\$\\$"));
        inAppBlacklistRegexps.add(Pattern.compile("\\$\\$Enhancer[a-zA-Z]*CGLIB\\$\\$"));
    }
}

