/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;
import shade.ru.endlesscode.rpginventory.jackson.Base64Variant;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.jackson.JsonStreamContext;
import shade.ru.endlesscode.rpginventory.jackson.ObjectCodec;
import shade.ru.endlesscode.rpginventory.jackson.SerializableString;
import shade.ru.endlesscode.rpginventory.jackson.TreeNode;
import shade.ru.endlesscode.rpginventory.jackson.Version;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class SentryJsonGenerator
extends JsonGenerator {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);
    private static final String RECURSION_LIMIT_HIT = "<recursion limit hit>";
    private static final int MAX_LENGTH_LIST = 10;
    private static final int MAX_SIZE_MAP = 50;
    private static final int MAX_LENGTH_STRING = 400;
    private static final int MAX_NESTING = 3;
    private static final String ELIDED = "...";
    private int maxLengthList;
    private int maxLengthString;
    private int maxSizeMap;
    private int maxNesting;
    private JsonGenerator generator;

    public SentryJsonGenerator(JsonGenerator jsonGenerator) {
        this.generator = jsonGenerator;
        this.maxLengthList = 10;
        this.maxLengthString = 400;
        this.maxSizeMap = 50;
        this.maxNesting = 3;
    }

    @Override
    public void writeObject(Object object) {
        this.writeObject(object, 0);
    }

    private void writeObject(Object object, int n) {
        if (n >= this.maxNesting) {
            this.generator.writeString(RECURSION_LIMIT_HIT);
            return;
        }
        if (object == null) {
            this.generator.writeNull();
        } else if (object.getClass().isArray()) {
            this.generator.writeStartArray();
            this.writeArray(object, n);
            this.generator.writeEndArray();
        } else if (object instanceof Map) {
            this.generator.writeStartObject();
            int n2 = 0;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                if (n2 >= this.maxSizeMap) break;
                if (entry.getKey() == null) {
                    this.generator.writeFieldName("null");
                } else {
                    this.generator.writeFieldName(Util.trimString(entry.getKey().toString(), this.maxLengthString));
                }
                this.writeObject(entry.getValue(), n + 1);
                ++n2;
            }
            this.generator.writeEndObject();
        } else if (object instanceof Collection) {
            this.generator.writeStartArray();
            int n3 = 0;
            for (Object e : (Collection)object) {
                if (n3 >= this.maxLengthList) {
                    this.writeElided();
                    break;
                }
                this.writeObject(e, n + 1);
                ++n3;
            }
            this.generator.writeEndArray();
        } else if (object instanceof String) {
            this.generator.writeString(Util.trimString((String)object, this.maxLengthString));
        } else {
            try {
                this.generator.writeObject(object);
            }
            catch (IllegalStateException illegalStateException) {
                logger.debug("Couldn't marshal '{}' of type '{}', had to be converted into a String", object, (Object)object.getClass());
                try {
                    this.generator.writeString(Util.trimString(object.toString(), this.maxLengthString));
                }
                catch (Exception exception) {
                    this.generator.writeString("<exception calling toString on object>");
                }
            }
        }
    }

    private void writeArray(Object object, int n) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber((int)byArray[i]);
            }
            if (byArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber((int)sArray[i]);
            }
            if (sArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber(nArray[i]);
            }
            if (nArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            for (int i = 0; i < lArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber(lArray[i]);
            }
            if (lArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            for (int i = 0; i < fArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber(fArray[i]);
            }
            if (fArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof double[]) {
            double[] dArray = (double[])object;
            for (int i = 0; i < dArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeNumber(dArray[i]);
            }
            if (dArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof char[]) {
            char[] cArray = (char[])object;
            for (int i = 0; i < cArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeString(String.valueOf(cArray[i]));
            }
            if (cArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            for (int i = 0; i < blArray.length && i < this.maxLengthList; ++i) {
                this.generator.writeBoolean(blArray[i]);
            }
            if (blArray.length > this.maxLengthList) {
                this.writeElided();
            }
        } else {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length && i < this.maxLengthList; ++i) {
                this.writeObject(objectArray[i], n + 1);
            }
            if (objectArray.length > this.maxLengthList) {
                this.writeElided();
            }
        }
    }

    private void writeElided() {
        this.generator.writeString(ELIDED);
    }

    public void setMaxLengthList(int n) {
        this.maxLengthList = n;
    }

    public void setMaxLengthString(int n) {
        this.maxLengthString = n;
    }

    public void setMaxSizeMap(int n) {
        this.maxSizeMap = n;
    }

    public void setMaxNesting(int n) {
        this.maxNesting = n;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        return this.generator.setCodec(objectCodec);
    }

    @Override
    public ObjectCodec getCodec() {
        return this.generator.getCodec();
    }

    @Override
    public Version version() {
        return this.generator.version();
    }

    @Override
    public JsonGenerator enable(JsonGenerator.Feature feature) {
        return this.generator.enable(feature);
    }

    @Override
    public JsonGenerator disable(JsonGenerator.Feature feature) {
        return this.generator.disable(feature);
    }

    @Override
    public boolean isEnabled(JsonGenerator.Feature feature) {
        return this.generator.isEnabled(feature);
    }

    @Override
    public int getFeatureMask() {
        return this.generator.getFeatureMask();
    }

    @Override
    public JsonGenerator setFeatureMask(int n) {
        return this.generator.setFeatureMask(n);
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public void writeStartArray() {
        this.generator.writeStartArray();
    }

    @Override
    public void writeEndArray() {
        this.generator.writeEndArray();
    }

    @Override
    public void writeStartObject() {
        this.generator.writeStartObject();
    }

    @Override
    public void writeEndObject() {
        this.generator.writeEndObject();
    }

    @Override
    public void writeFieldName(String string) {
        this.generator.writeFieldName(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this.generator.writeFieldName(serializableString);
    }

    @Override
    public void writeString(String string) {
        this.generator.writeString(string);
    }

    @Override
    public void writeString(char[] cArray, int n, int n2) {
        this.generator.writeString(cArray, n, n2);
    }

    @Override
    public void writeString(SerializableString serializableString) {
        this.generator.writeString(serializableString);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n, int n2) {
        this.generator.writeRawUTF8String(byArray, n, n2);
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n, int n2) {
        this.generator.writeUTF8String(byArray, n, n2);
    }

    @Override
    public void writeRaw(String string) {
        this.generator.writeRaw(string);
    }

    @Override
    public void writeRaw(String string, int n, int n2) {
        this.generator.writeRaw(string, n, n2);
    }

    @Override
    public void writeRaw(char[] cArray, int n, int n2) {
        this.generator.writeRaw(cArray, n, n2);
    }

    @Override
    public void writeRaw(char c) {
        this.generator.writeRaw(c);
    }

    @Override
    public void writeRawValue(String string) {
        this.generator.writeRawValue(string);
    }

    @Override
    public void writeRawValue(String string, int n, int n2) {
        this.generator.writeRawValue(string, n, n2);
    }

    @Override
    public void writeRawValue(char[] cArray, int n, int n2) {
        this.generator.writeRawValue(cArray, n, n2);
    }

    @Override
    public void writeBinary(Base64Variant base64Variant, byte[] byArray, int n, int n2) {
        this.generator.writeBinary(base64Variant, byArray, n, n2);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n) {
        return this.generator.writeBinary(base64Variant, inputStream, n);
    }

    @Override
    public void writeNumber(int n) {
        this.generator.writeNumber(n);
    }

    @Override
    public void writeNumber(long l) {
        this.generator.writeNumber(l);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        this.generator.writeNumber(bigInteger);
    }

    @Override
    public void writeNumber(double d) {
        this.generator.writeNumber(d);
    }

    @Override
    public void writeNumber(float f) {
        this.generator.writeNumber(f);
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        this.generator.writeNumber(bigDecimal);
    }

    @Override
    public void writeNumber(String string) {
        this.generator.writeNumber(string);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.generator.writeBoolean(bl);
    }

    @Override
    public void writeNull() {
        this.generator.writeNull();
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        this.generator.writeTree(treeNode);
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this.generator.getOutputContext();
    }

    @Override
    public void flush() {
        this.generator.flush();
    }

    @Override
    public boolean isClosed() {
        return this.generator.isClosed();
    }

    @Override
    public void close() {
        this.generator.close();
    }
}

