/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.MessageInterface;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.InterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;

public class MessageInterfaceBinding
implements InterfaceBinding<MessageInterface> {
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 1000;
    private static final String MESSAGE_PARAMETER = "message";
    private static final String PARAMS_PARAMETER = "params";
    private static final String FORMATTED_PARAMETER = "formatted";
    private final int maxMessageLength;

    public MessageInterfaceBinding() {
        this.maxMessageLength = 1000;
    }

    public MessageInterfaceBinding(int n) {
        this.maxMessageLength = n;
    }

    @Override
    public void writeInterface(JsonGenerator jsonGenerator, MessageInterface messageInterface) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(MESSAGE_PARAMETER, Util.trimString(messageInterface.getMessage(), this.maxMessageLength));
        jsonGenerator.writeArrayFieldStart(PARAMS_PARAMETER);
        for (String string : messageInterface.getParameters()) {
            jsonGenerator.writeString(string);
        }
        jsonGenerator.writeEndArray();
        if (messageInterface.getFormatted() != null) {
            jsonGenerator.writeStringField(FORMATTED_PARAMETER, Util.trimString(messageInterface.getFormatted(), this.maxMessageLength));
        }
        jsonGenerator.writeEndObject();
    }
}

