/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import shade.ru.endlesscode.rpginventory.jackson.JsonFactory;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.event.Breadcrumb;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.event.Sdk;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryInterface;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.Marshaller;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.InterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.SentryJsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class JsonMarshaller
implements Marshaller {
    public static final String EVENT_ID = "event_id";
    public static final String MESSAGE = "message";
    public static final String TIMESTAMP = "timestamp";
    public static final String LEVEL = "level";
    public static final String LOGGER = "logger";
    public static final String PLATFORM = "platform";
    public static final String CULPRIT = "culprit";
    public static final String TRANSACTION = "transaction";
    public static final String SDK = "sdk";
    public static final String TAGS = "tags";
    public static final String BREADCRUMBS = "breadcrumbs";
    public static final String CONTEXTS = "contexts";
    public static final String SERVER_NAME = "server_name";
    public static final String RELEASE = "release";
    public static final String DIST = "dist";
    public static final String ENVIRONMENT = "environment";
    public static final String FINGERPRINT = "fingerprint";
    public static final String MODULES = "modules";
    public static final String EXTRA = "extra";
    public static final String CHECKSUM = "checksum";
    public static final int DEFAULT_MAX_MESSAGE_LENGTH = 1000;
    private static final ThreadLocal<DateFormat> ISO_FORMAT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return simpleDateFormat;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(JsonMarshaller.class);
    private final JsonFactory jsonFactory = new JsonFactory();
    private final Map<Class<? extends SentryInterface>, InterfaceBinding<?>> interfaceBindings = new HashMap();
    private boolean compression = true;
    private final int maxMessageLength;

    public JsonMarshaller() {
        this(1000);
    }

    public JsonMarshaller(int n) {
        this.maxMessageLength = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshall(Event event2, OutputStream outputStream) {
        outputStream = new Marshaller.UncloseableOutputStream(outputStream);
        if (this.compression) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        try (JsonGenerator jsonGenerator = this.createJsonGenerator(outputStream);){
            this.writeContent(jsonGenerator, event2);
        }
        catch (IOException iOException) {
            logger.error("An exception occurred while serialising the event.", iOException);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                logger.error("An exception occurred while serialising the event.", iOException);
            }
        }
    }

    protected JsonGenerator createJsonGenerator(OutputStream outputStream) {
        return new SentryJsonGenerator(this.jsonFactory.createGenerator(outputStream));
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String getContentEncoding() {
        if (this.isCompressed()) {
            return "gzip";
        }
        return null;
    }

    private void writeContent(JsonGenerator jsonGenerator, Event event2) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(EVENT_ID, this.formatId(event2.getId()));
        jsonGenerator.writeStringField(MESSAGE, Util.trimString(event2.getMessage(), this.maxMessageLength));
        jsonGenerator.writeStringField(TIMESTAMP, ISO_FORMAT.get().format(event2.getTimestamp()));
        jsonGenerator.writeStringField(LEVEL, this.formatLevel(event2.getLevel()));
        jsonGenerator.writeStringField(LOGGER, event2.getLogger());
        jsonGenerator.writeStringField(PLATFORM, event2.getPlatform());
        jsonGenerator.writeStringField(CULPRIT, event2.getCulprit());
        jsonGenerator.writeStringField(TRANSACTION, event2.getTransaction());
        this.writeSdk(jsonGenerator, event2.getSdk());
        this.writeTags(jsonGenerator, event2.getTags());
        this.writeBreadcumbs(jsonGenerator, event2.getBreadcrumbs());
        this.writeContexts(jsonGenerator, event2.getContexts());
        jsonGenerator.writeStringField(SERVER_NAME, event2.getServerName());
        jsonGenerator.writeStringField(RELEASE, event2.getRelease());
        jsonGenerator.writeStringField(DIST, event2.getDist());
        jsonGenerator.writeStringField(ENVIRONMENT, event2.getEnvironment());
        this.writeExtras(jsonGenerator, event2.getExtra());
        this.writeCollection(jsonGenerator, FINGERPRINT, event2.getFingerprint());
        jsonGenerator.writeStringField(CHECKSUM, event2.getChecksum());
        this.writeInterfaces(jsonGenerator, event2.getSentryInterfaces());
        jsonGenerator.writeEndObject();
    }

    private void writeInterfaces(JsonGenerator jsonGenerator, Map<String, SentryInterface> map) {
        for (Map.Entry<String, SentryInterface> entry : map.entrySet()) {
            SentryInterface sentryInterface = entry.getValue();
            if (this.interfaceBindings.containsKey(sentryInterface.getClass())) {
                jsonGenerator.writeFieldName(entry.getKey());
                this.getInterfaceBinding(sentryInterface).writeInterface(jsonGenerator, entry.getValue());
                continue;
            }
            logger.error("Couldn't parse the content of '{}' provided in {}.", (Object)entry.getKey(), (Object)sentryInterface);
        }
    }

    private <T extends SentryInterface> InterfaceBinding<? super T> getInterfaceBinding(T t) {
        return this.interfaceBindings.get(t.getClass());
    }

    private void writeExtras(JsonGenerator jsonGenerator, Map<String, Object> map) {
        jsonGenerator.writeObjectFieldStart(EXTRA);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey());
            jsonGenerator.writeObject(entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeCollection(JsonGenerator jsonGenerator, String string, Collection<String> collection) {
        if (collection != null && !collection.isEmpty()) {
            jsonGenerator.writeArrayFieldStart(string);
            for (String string2 : collection) {
                jsonGenerator.writeString(string2);
            }
            jsonGenerator.writeEndArray();
        }
    }

    private void writeSdk(JsonGenerator jsonGenerator, Sdk sdk) {
        jsonGenerator.writeObjectFieldStart(SDK);
        jsonGenerator.writeStringField("name", sdk.getName());
        jsonGenerator.writeStringField("version", sdk.getVersion());
        if (sdk.getIntegrations() != null && !sdk.getIntegrations().isEmpty()) {
            jsonGenerator.writeArrayFieldStart("integrations");
            for (String string : sdk.getIntegrations()) {
                jsonGenerator.writeString(string);
            }
            jsonGenerator.writeEndArray();
        }
        jsonGenerator.writeEndObject();
    }

    private void writeTags(JsonGenerator jsonGenerator, Map<String, String> map) {
        jsonGenerator.writeObjectFieldStart(TAGS);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeBreadcumbs(JsonGenerator jsonGenerator, List<Breadcrumb> list) {
        if (list.isEmpty()) {
            return;
        }
        jsonGenerator.writeObjectFieldStart(BREADCRUMBS);
        jsonGenerator.writeArrayFieldStart("values");
        for (Breadcrumb breadcrumb : list) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeNumberField(TIMESTAMP, breadcrumb.getTimestamp().getTime() / 1000L);
            if (breadcrumb.getType() != null) {
                jsonGenerator.writeStringField("type", breadcrumb.getType().getValue());
            }
            if (breadcrumb.getLevel() != null) {
                jsonGenerator.writeStringField(LEVEL, breadcrumb.getLevel().getValue());
            }
            if (breadcrumb.getMessage() != null) {
                jsonGenerator.writeStringField(MESSAGE, breadcrumb.getMessage());
            }
            if (breadcrumb.getCategory() != null) {
                jsonGenerator.writeStringField("category", breadcrumb.getCategory());
            }
            if (breadcrumb.getData() != null && !breadcrumb.getData().isEmpty()) {
                jsonGenerator.writeObjectFieldStart("data");
                for (Map.Entry<String, String> entry : breadcrumb.getData().entrySet()) {
                    jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    private void writeContexts(JsonGenerator jsonGenerator, Map<String, Map<String, Object>> map) {
        if (map.isEmpty()) {
            return;
        }
        jsonGenerator.writeObjectFieldStart(CONTEXTS);
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            jsonGenerator.writeObjectFieldStart(entry.getKey());
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                jsonGenerator.writeObjectField(entry2.getKey(), entry2.getValue());
            }
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndObject();
    }

    private String formatId(UUID uUID) {
        return uUID.toString().replaceAll("-", "");
    }

    private String formatLevel(Event.Level level) {
        if (level == null) {
            return null;
        }
        switch (level) {
            case DEBUG: {
                return "debug";
            }
            case FATAL: {
                return "fatal";
            }
            case WARNING: {
                return "warning";
            }
            case INFO: {
                return "info";
            }
            case ERROR: {
                return "error";
            }
        }
        logger.error("The level '{}' isn't supported, this should NEVER happen, contact Sentry developers", (Object)level.name());
        return null;
    }

    public <T extends SentryInterface, F extends T> void addInterfaceBinding(Class<F> clazz, InterfaceBinding<T> interfaceBinding) {
        this.interfaceBindings.put(clazz, interfaceBinding);
    }

    public void setCompression(boolean bl) {
        this.compression = bl;
    }

    public boolean isCompressed() {
        return this.compression;
    }
}

