/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import java.util.Collection;
import java.util.Map;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.HttpInterface;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.InterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;

public class HttpInterfaceBinding
implements InterfaceBinding<HttpInterface> {
    public static final int MAX_BODY_LENGTH = 2048;
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String DATA = "data";
    private static final String BODY = "body";
    private static final String QUERY_STRING = "query_string";
    private static final String COOKIES = "cookies";
    private static final String HEADERS = "headers";
    private static final String ENVIRONMENT = "env";
    private static final String ENV_REMOTE_ADDR = "REMOTE_ADDR";
    private static final String ENV_SERVER_NAME = "SERVER_NAME";
    private static final String ENV_SERVER_PORT = "SERVER_PORT";
    private static final String ENV_LOCAL_ADDR = "LOCAL_ADDR";
    private static final String ENV_LOCAL_NAME = "LOCAL_NAME";
    private static final String ENV_LOCAL_PORT = "LOCAL_PORT";
    private static final String ENV_SERVER_PROTOCOL = "SERVER_PROTOCOL";
    private static final String ENV_REQUEST_SECURE = "REQUEST_SECURE";
    private static final String ENV_REQUEST_ASYNC = "REQUEST_ASYNC";
    private static final String ENV_AUTH_TYPE = "AUTH_TYPE";
    private static final String ENV_REMOTE_USER = "REMOTE_USER";

    @Override
    public void writeInterface(JsonGenerator jsonGenerator, HttpInterface httpInterface) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(URL, httpInterface.getRequestUrl());
        jsonGenerator.writeStringField(METHOD, httpInterface.getMethod());
        jsonGenerator.writeFieldName(DATA);
        this.writeData(jsonGenerator, httpInterface.getParameters(), httpInterface.getBody());
        jsonGenerator.writeStringField(QUERY_STRING, httpInterface.getQueryString());
        jsonGenerator.writeFieldName(COOKIES);
        this.writeCookies(jsonGenerator, httpInterface.getCookies());
        jsonGenerator.writeFieldName(HEADERS);
        this.writeHeaders(jsonGenerator, httpInterface.getHeaders());
        jsonGenerator.writeFieldName(ENVIRONMENT);
        this.writeEnvironment(jsonGenerator, httpInterface);
        jsonGenerator.writeEndObject();
    }

    private void writeEnvironment(JsonGenerator jsonGenerator, HttpInterface httpInterface) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(ENV_REMOTE_ADDR, httpInterface.getRemoteAddr());
        jsonGenerator.writeStringField(ENV_SERVER_NAME, httpInterface.getServerName());
        jsonGenerator.writeNumberField(ENV_SERVER_PORT, httpInterface.getServerPort());
        jsonGenerator.writeStringField(ENV_LOCAL_ADDR, httpInterface.getLocalAddr());
        jsonGenerator.writeStringField(ENV_LOCAL_NAME, httpInterface.getLocalName());
        jsonGenerator.writeNumberField(ENV_LOCAL_PORT, httpInterface.getLocalPort());
        jsonGenerator.writeStringField(ENV_SERVER_PROTOCOL, httpInterface.getProtocol());
        jsonGenerator.writeBooleanField(ENV_REQUEST_SECURE, httpInterface.isSecure());
        jsonGenerator.writeBooleanField(ENV_REQUEST_ASYNC, httpInterface.isAsyncStarted());
        jsonGenerator.writeStringField(ENV_AUTH_TYPE, httpInterface.getAuthType());
        jsonGenerator.writeStringField(ENV_REMOTE_USER, httpInterface.getRemoteUser());
        jsonGenerator.writeEndObject();
    }

    private void writeHeaders(JsonGenerator jsonGenerator, Map<String, Collection<String>> map) {
        jsonGenerator.writeStartArray();
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            for (String string : entry.getValue()) {
                jsonGenerator.writeStartArray();
                jsonGenerator.writeString(entry.getKey());
                jsonGenerator.writeString(string);
                jsonGenerator.writeEndArray();
            }
        }
        jsonGenerator.writeEndArray();
    }

    private void writeCookies(JsonGenerator jsonGenerator, Map<String, String> map) {
        if (map.isEmpty()) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeStartObject();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    private void writeData(JsonGenerator jsonGenerator, Map<String, Collection<String>> map, String string) {
        if (map == null && string == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeStartObject();
        if (string != null) {
            jsonGenerator.writeStringField(BODY, Util.trimString(string, 2048));
        }
        if (map != null) {
            for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
                jsonGenerator.writeArrayFieldStart(entry.getKey());
                for (String string2 : entry.getValue()) {
                    jsonGenerator.writeString(string2);
                }
                jsonGenerator.writeEndArray();
            }
        }
        jsonGenerator.writeEndObject();
    }
}

