/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.marshaller.json;

import java.util.Deque;
import java.util.Iterator;
import shade.ru.endlesscode.rpginventory.jackson.JsonGenerator;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.ExceptionInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryException;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.StackTraceInterface;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.InterfaceBinding;

public class ExceptionInterfaceBinding
implements InterfaceBinding<ExceptionInterface> {
    private static final String TYPE_PARAMETER = "type";
    private static final String VALUE_PARAMETER = "value";
    private static final String MODULE_PARAMETER = "module";
    private static final String STACKTRACE_PARAMETER = "stacktrace";
    private final InterfaceBinding<StackTraceInterface> stackTraceInterfaceBinding;

    public ExceptionInterfaceBinding(InterfaceBinding<StackTraceInterface> interfaceBinding) {
        this.stackTraceInterfaceBinding = interfaceBinding;
    }

    @Override
    public void writeInterface(JsonGenerator jsonGenerator, ExceptionInterface exceptionInterface) {
        Deque<SentryException> deque = exceptionInterface.getExceptions();
        jsonGenerator.writeStartArray();
        Iterator<SentryException> iterator2 = deque.descendingIterator();
        while (iterator2.hasNext()) {
            this.writeException(jsonGenerator, iterator2.next());
        }
        jsonGenerator.writeEndArray();
    }

    private void writeException(JsonGenerator jsonGenerator, SentryException sentryException) {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField(TYPE_PARAMETER, sentryException.getExceptionClassName());
        jsonGenerator.writeStringField(VALUE_PARAMETER, sentryException.getExceptionMessage());
        jsonGenerator.writeStringField(MODULE_PARAMETER, sentryException.getExceptionPackageName());
        jsonGenerator.writeFieldName(STACKTRACE_PARAMETER);
        this.stackTraceInterfaceBinding.writeInterface(jsonGenerator, sentryException.getStackTraceInterface());
        jsonGenerator.writeEndObject();
    }
}

