/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.jvmti;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import shade.ru.endlesscode.rpginventory.sentry.jvmti.Frame;

public final class FrameCache {
    private static Set<String> appPackages = new HashSet<String>();
    private static ThreadLocal<WeakHashMap<Throwable, Frame[]>> cache = new ThreadLocal<WeakHashMap<Throwable, Frame[]>>(){

        @Override
        protected WeakHashMap<Throwable, Frame[]> initialValue() {
            return new WeakHashMap<Throwable, Frame[]>();
        }
    };

    private FrameCache() {
    }

    public static void add(Throwable throwable, Frame[] frameArray) {
        Map map = cache.get();
        map.put(throwable, frameArray);
    }

    public static Frame[] get(Throwable throwable) {
        Map map = cache.get();
        return (Frame[])map.get(throwable);
    }

    public static boolean shouldCacheThrowable(Throwable throwable, int n) {
        if (appPackages.isEmpty()) {
            return false;
        }
        Map map = cache.get();
        Frame[] frameArray = (Frame[])map.get(throwable);
        if (frameArray != null && n <= frameArray.length) {
            return false;
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            for (String string : appPackages) {
                if (!stackTraceElement.getClassName().startsWith(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAppPackage(String string) {
        appPackages.add(string);
    }
}

