/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.jvmti;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Frame {
    private Method method;
    private final LocalVariable[] locals;

    public Frame(Method method, LocalVariable[] localVariableArray) {
        this.method = method;
        this.locals = localVariableArray;
    }

    public Method getMethod() {
        return this.method;
    }

    public Map<String, Object> getLocals() {
        if (this.locals == null || this.locals.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (LocalVariable localVariable : this.locals) {
            if (localVariable == null) continue;
            hashMap.put(localVariable.getName(), localVariable.getValue());
        }
        return hashMap;
    }

    public String toString() {
        return "Frame{, locals=" + Arrays.toString(this.locals) + '}';
    }

    public static final class LocalVariable {
        final String name;
        final Object value;

        public LocalVariable(String string, Object object) {
            this.name = string;
            this.value = object;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "LocalVariable{name='" + this.name + '\'' + ", value=" + this.value + '}';
        }
    }
}

