/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.interfaces;

import java.util.Arrays;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryStackTraceElement;
import shade.ru.endlesscode.rpginventory.sentry.jvmti.Frame;

public class StackTraceInterface
implements SentryInterface {
    public static final String STACKTRACE_INTERFACE = "sentry.interfaces.Stacktrace";
    private final SentryStackTraceElement[] stackTrace;
    private final int framesCommonWithEnclosing;

    public StackTraceInterface(StackTraceElement[] stackTraceElementArray) {
        this(stackTraceElementArray, new StackTraceElement[0], null);
    }

    public StackTraceInterface(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2) {
        this(stackTraceElementArray, stackTraceElementArray2, null);
    }

    public StackTraceInterface(StackTraceElement[] stackTraceElementArray, StackTraceElement[] stackTraceElementArray2, Frame[] frameArray) {
        this.stackTrace = SentryStackTraceElement.fromStackTraceElements(stackTraceElementArray, frameArray);
        int n = stackTraceElementArray.length - 1;
        for (int i = stackTraceElementArray2.length - 1; n >= 0 && i >= 0 && stackTraceElementArray[n].equals(stackTraceElementArray2[i]); --n, --i) {
        }
        this.framesCommonWithEnclosing = stackTraceElementArray.length - 1 - n;
    }

    public StackTraceInterface(SentryStackTraceElement[] sentryStackTraceElementArray) {
        this.stackTrace = Arrays.copyOf(sentryStackTraceElementArray, sentryStackTraceElementArray.length);
        this.framesCommonWithEnclosing = 0;
    }

    @Override
    public String getInterfaceName() {
        return STACKTRACE_INTERFACE;
    }

    public SentryStackTraceElement[] getStackTrace() {
        return Arrays.copyOf(this.stackTrace, this.stackTrace.length);
    }

    public int getFramesCommonWithEnclosing() {
        return this.framesCommonWithEnclosing;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StackTraceInterface stackTraceInterface = (StackTraceInterface)object;
        return Arrays.equals(this.stackTrace, stackTraceInterface.stackTrace);
    }

    public int hashCode() {
        return Arrays.hashCode(this.stackTrace);
    }

    public String toString() {
        return "StackTraceInterface{stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }
}

