/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.interfaces;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import shade.ru.endlesscode.rpginventory.sentry.jvmti.Frame;

public class SentryStackTraceElement
implements Serializable {
    private final String module;
    private final String function;
    private final String fileName;
    private final int lineno;
    private final Integer colno;
    private final String absPath;
    private final String platform;
    private final Map<String, Object> locals;

    public SentryStackTraceElement(String string, String string2, String string3, int n, Integer n2, String string4, String string5) {
        this(string, string2, string3, n, n2, string4, string5, null);
    }

    public SentryStackTraceElement(String string, String string2, String string3, int n, Integer n2, String string4, String string5, Map<String, Object> map) {
        this.module = string;
        this.function = string2;
        this.fileName = string3;
        this.lineno = n;
        this.colno = n2;
        this.absPath = string4;
        this.platform = string5;
        this.locals = map;
    }

    public String getModule() {
        return this.module;
    }

    public String getFunction() {
        return this.function;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineno() {
        return this.lineno;
    }

    public Integer getColno() {
        return this.colno;
    }

    public String getAbsPath() {
        return this.absPath;
    }

    public String getPlatform() {
        return this.platform;
    }

    public Map<String, Object> getLocals() {
        return this.locals;
    }

    public static SentryStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElementArray) {
        return SentryStackTraceElement.fromStackTraceElements(stackTraceElementArray, null);
    }

    public static SentryStackTraceElement[] fromStackTraceElements(StackTraceElement[] stackTraceElementArray, Frame[] frameArray) {
        SentryStackTraceElement[] sentryStackTraceElementArray = new SentryStackTraceElement[stackTraceElementArray.length];
        int n = 0;
        int n2 = 0;
        while (n < stackTraceElementArray.length) {
            StackTraceElement stackTraceElement = stackTraceElementArray[n];
            Map<String, Object> map = null;
            if (frameArray != null) {
                while (n2 < frameArray.length && !frameArray[n2].getMethod().getName().equals(stackTraceElement.getMethodName())) {
                    ++n2;
                }
                if (n2 < frameArray.length) {
                    map = frameArray[n2].getLocals();
                }
            }
            sentryStackTraceElementArray[n] = SentryStackTraceElement.fromStackTraceElement(stackTraceElement, map);
            ++n;
            ++n2;
        }
        return sentryStackTraceElementArray;
    }

    public static SentryStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement) {
        return SentryStackTraceElement.fromStackTraceElement(stackTraceElement, null);
    }

    private static SentryStackTraceElement fromStackTraceElement(StackTraceElement stackTraceElement, Map<String, Object> map) {
        return new SentryStackTraceElement(stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getFileName(), stackTraceElement.getLineNumber(), null, null, null, map);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SentryStackTraceElement sentryStackTraceElement = (SentryStackTraceElement)object;
        return this.lineno == sentryStackTraceElement.lineno && Objects.equals(this.module, sentryStackTraceElement.module) && Objects.equals(this.function, sentryStackTraceElement.function) && Objects.equals(this.fileName, sentryStackTraceElement.fileName) && Objects.equals(this.colno, sentryStackTraceElement.colno) && Objects.equals(this.absPath, sentryStackTraceElement.absPath) && Objects.equals(this.platform, sentryStackTraceElement.platform) && Objects.equals(this.locals, sentryStackTraceElement.locals);
    }

    public int hashCode() {
        return Objects.hash(this.module, this.function, this.fileName, this.lineno, this.colno, this.absPath, this.platform, this.locals);
    }

    public String toString() {
        return "SentryStackTraceElement{module='" + this.module + '\'' + ", function='" + this.function + '\'' + ", fileName='" + this.fileName + '\'' + ", lineno=" + this.lineno + ", colno=" + this.colno + ", absPath='" + this.absPath + '\'' + ", platform='" + this.platform + '\'' + ", locals='" + this.locals + '\'' + '}';
    }
}

