/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.interfaces;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.StackTraceInterface;
import shade.ru.endlesscode.rpginventory.sentry.jvmti.FrameCache;

public final class SentryException
implements Serializable {
    public static final String DEFAULT_PACKAGE_NAME = "(default)";
    private final String exceptionMessage;
    private final String exceptionClassName;
    private final String exceptionPackageName;
    private final StackTraceInterface stackTraceInterface;

    public SentryException(Throwable throwable, StackTraceElement[] stackTraceElementArray) {
        this.exceptionMessage = throwable.getMessage();
        this.exceptionClassName = throwable.getClass().getSimpleName();
        Package package_ = throwable.getClass().getPackage();
        this.exceptionPackageName = package_ != null ? package_.getName() : null;
        this.stackTraceInterface = new StackTraceInterface(throwable.getStackTrace(), stackTraceElementArray, FrameCache.get(throwable));
    }

    public SentryException(String string, String string2, String string3, StackTraceInterface stackTraceInterface) {
        this.exceptionMessage = string;
        this.exceptionClassName = string2;
        this.exceptionPackageName = string3;
        this.stackTraceInterface = stackTraceInterface;
    }

    public static Deque<SentryException> extractExceptionQueue(Throwable throwable) {
        ArrayDeque<SentryException> arrayDeque = new ArrayDeque<SentryException>();
        HashSet<Throwable> hashSet = new HashSet<Throwable>();
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null && hashSet.add(throwable)) {
            arrayDeque.add(new SentryException(throwable, stackTraceElementArray));
            stackTraceElementArray = throwable.getStackTrace();
            throwable = throwable.getCause();
        }
        return arrayDeque;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionPackageName() {
        return this.exceptionPackageName != null ? this.exceptionPackageName : DEFAULT_PACKAGE_NAME;
    }

    public StackTraceInterface getStackTraceInterface() {
        return this.stackTraceInterface;
    }

    public String toString() {
        return "SentryException{exceptionMessage='" + this.exceptionMessage + '\'' + ", exceptionClassName='" + this.exceptionClassName + '\'' + ", exceptionPackageName='" + this.exceptionPackageName + '\'' + ", stackTraceInterface=" + this.stackTraceInterface + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SentryException sentryException = (SentryException)object;
        if (!this.exceptionClassName.equals(sentryException.exceptionClassName)) {
            return false;
        }
        if (this.exceptionMessage != null ? !this.exceptionMessage.equals(sentryException.exceptionMessage) : sentryException.exceptionMessage != null) {
            return false;
        }
        if (this.exceptionPackageName != null ? !this.exceptionPackageName.equals(sentryException.exceptionPackageName) : sentryException.exceptionPackageName != null) {
            return false;
        }
        return this.stackTraceInterface.equals(sentryException.stackTraceInterface);
    }

    public int hashCode() {
        int n = this.exceptionMessage != null ? this.exceptionMessage.hashCode() : 0;
        n = 31 * n + this.exceptionClassName.hashCode();
        n = 31 * n + (this.exceptionPackageName != null ? this.exceptionPackageName.hashCode() : 0);
        return n;
    }
}

