/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.interfaces;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.BasicRemoteAddressResolver;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.RemoteAddressResolver;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryInterface;

public class HttpInterface
implements SentryInterface {
    public static final String HTTP_INTERFACE = "sentry.interfaces.Http";
    private final String requestUrl;
    private final String method;
    private final Map<String, Collection<String>> parameters;
    private final String queryString;
    private final Map<String, String> cookies;
    private final String remoteAddr;
    private final String serverName;
    private final int serverPort;
    private final String localAddr;
    private final String localName;
    private final int localPort;
    private final String protocol;
    private final boolean secure;
    private final boolean asyncStarted;
    private final String authType;
    private final String remoteUser;
    private final Map<String, Collection<String>> headers;
    private final String body;

    public HttpInterface(HttpServletRequest httpServletRequest) {
        this(httpServletRequest, new BasicRemoteAddressResolver());
    }

    public HttpInterface(HttpServletRequest httpServletRequest, RemoteAddressResolver remoteAddressResolver) {
        this(httpServletRequest, remoteAddressResolver, null);
    }

    public HttpInterface(HttpServletRequest httpServletRequest, RemoteAddressResolver remoteAddressResolver, String string) {
        this.requestUrl = httpServletRequest.getRequestURL().toString();
        this.method = httpServletRequest.getMethod();
        this.parameters = new HashMap<String, Collection<String>>();
        for (Map.Entry entry : httpServletRequest.getParameterMap().entrySet()) {
            this.parameters.put((String)entry.getKey(), (Collection<String>)Arrays.asList((Object[])entry.getValue()));
        }
        this.queryString = httpServletRequest.getQueryString();
        if (httpServletRequest.getCookies() != null) {
            this.cookies = new HashMap<String, String>();
            for (Cookie cookie : httpServletRequest.getCookies()) {
                this.cookies.put(cookie.getName(), cookie.getValue());
            }
        } else {
            this.cookies = Collections.emptyMap();
        }
        this.remoteAddr = remoteAddressResolver.getRemoteAddress(httpServletRequest);
        this.serverName = httpServletRequest.getServerName();
        this.serverPort = httpServletRequest.getServerPort();
        this.localAddr = httpServletRequest.getLocalAddr();
        this.localName = httpServletRequest.getLocalName();
        this.localPort = httpServletRequest.getLocalPort();
        this.protocol = httpServletRequest.getProtocol();
        this.secure = httpServletRequest.isSecure();
        this.asyncStarted = httpServletRequest.isAsyncStarted();
        this.authType = httpServletRequest.getAuthType();
        this.remoteUser = httpServletRequest.getRemoteUser();
        this.headers = new HashMap<String, Collection<String>>();
        for (String string2 : Collections.list(httpServletRequest.getHeaderNames())) {
            this.headers.put(string2, Collections.list(httpServletRequest.getHeaders(string2)));
        }
        this.body = string;
    }

    @Override
    public String getInterfaceName() {
        return HTTP_INTERFACE;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, Collection<String>> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getLocalAddr() {
        return this.localAddr;
    }

    public String getLocalName() {
        return this.localName;
    }

    public int getLocalPort() {
        return this.localPort;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isAsyncStarted() {
        return this.asyncStarted;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, Collection<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public String toString() {
        return "HttpInterface{requestUrl='" + this.requestUrl + '\'' + ", method='" + this.method + '\'' + ", queryString='" + this.queryString + '\'' + ", parameters=" + this.parameters + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HttpInterface httpInterface = (HttpInterface)object;
        if (this.asyncStarted != httpInterface.asyncStarted) {
            return false;
        }
        if (this.localPort != httpInterface.localPort) {
            return false;
        }
        if (this.secure != httpInterface.secure) {
            return false;
        }
        if (this.serverPort != httpInterface.serverPort) {
            return false;
        }
        if (this.authType != null ? !this.authType.equals(httpInterface.authType) : httpInterface.authType != null) {
            return false;
        }
        if (!this.cookies.equals(httpInterface.cookies)) {
            return false;
        }
        if (!this.headers.equals(httpInterface.headers)) {
            return false;
        }
        if (this.localAddr != null ? !this.localAddr.equals(httpInterface.localAddr) : httpInterface.localAddr != null) {
            return false;
        }
        if (this.localName != null ? !this.localName.equals(httpInterface.localName) : httpInterface.localName != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(httpInterface.method) : httpInterface.method != null) {
            return false;
        }
        if (!this.parameters.equals(httpInterface.parameters)) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(httpInterface.protocol) : httpInterface.protocol != null) {
            return false;
        }
        if (this.queryString != null ? !this.queryString.equals(httpInterface.queryString) : httpInterface.queryString != null) {
            return false;
        }
        if (this.remoteAddr != null ? !this.remoteAddr.equals(httpInterface.remoteAddr) : httpInterface.remoteAddr != null) {
            return false;
        }
        if (this.remoteUser != null ? !this.remoteUser.equals(httpInterface.remoteUser) : httpInterface.remoteUser != null) {
            return false;
        }
        if (!this.requestUrl.equals(httpInterface.requestUrl)) {
            return false;
        }
        if (this.serverName != null ? !this.serverName.equals(httpInterface.serverName) : httpInterface.serverName != null) {
            return false;
        }
        return !(this.body != null ? !this.body.equals(httpInterface.body) : httpInterface.body != null);
    }

    public int hashCode() {
        int n = this.requestUrl.hashCode();
        n = 31 * n + (this.method != null ? this.method.hashCode() : 0);
        n = 31 * n + this.parameters.hashCode();
        return n;
    }
}

