/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.helper;

import javax.servlet.http.HttpServletRequest;
import shade.ru.endlesscode.rpginventory.sentry.event.EventBuilder;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.BasicRemoteAddressResolver;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.EventBuilderHelper;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.RemoteAddressResolver;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.HttpInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.UserInterface;
import shade.ru.endlesscode.rpginventory.sentry.servlet.SentryServletRequestListener;

public class HttpEventBuilderHelper
implements EventBuilderHelper {
    private final RemoteAddressResolver remoteAddressResolver;

    public HttpEventBuilderHelper() {
        this.remoteAddressResolver = new BasicRemoteAddressResolver();
    }

    public HttpEventBuilderHelper(RemoteAddressResolver remoteAddressResolver) {
        this.remoteAddressResolver = remoteAddressResolver;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        HttpServletRequest httpServletRequest = SentryServletRequestListener.getServletRequest();
        if (httpServletRequest == null) {
            return;
        }
        this.addHttpInterface(eventBuilder, httpServletRequest);
        this.addUserInterface(eventBuilder, httpServletRequest);
    }

    private void addHttpInterface(EventBuilder eventBuilder, HttpServletRequest httpServletRequest) {
        eventBuilder.withSentryInterface(new HttpInterface(httpServletRequest, this.remoteAddressResolver), false);
    }

    private void addUserInterface(EventBuilder eventBuilder, HttpServletRequest httpServletRequest) {
        String string = null;
        if (httpServletRequest.getUserPrincipal() != null) {
            string = httpServletRequest.getUserPrincipal().getName();
        }
        UserInterface userInterface = new UserInterface(null, string, this.remoteAddressResolver.getRemoteAddress(httpServletRequest), null);
        eventBuilder.withSentryInterface(userInterface, false);
    }

    public RemoteAddressResolver getRemoteAddressResolver() {
        return this.remoteAddressResolver;
    }
}

