/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event.helper;

import java.util.List;
import java.util.Map;
import shade.ru.endlesscode.rpginventory.sentry.SentryClient;
import shade.ru.endlesscode.rpginventory.sentry.context.Context;
import shade.ru.endlesscode.rpginventory.sentry.event.Breadcrumb;
import shade.ru.endlesscode.rpginventory.sentry.event.EventBuilder;
import shade.ru.endlesscode.rpginventory.sentry.event.User;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.EventBuilderHelper;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.UserInterface;

public class ContextBuilderHelper
implements EventBuilderHelper {
    private SentryClient sentryClient;

    public ContextBuilderHelper(SentryClient sentryClient) {
        this.sentryClient = sentryClient;
    }

    @Override
    public void helpBuildingEvent(EventBuilder eventBuilder) {
        Object object;
        Map<String, String> map;
        Context context = this.sentryClient.getContext();
        List<Breadcrumb> list = context.getBreadcrumbs();
        if (!list.isEmpty()) {
            eventBuilder.withBreadcrumbs(list);
        }
        if (context.getUser() != null) {
            eventBuilder.withSentryInterface(this.fromUser(context.getUser()));
        }
        if (!(map = context.getTags()).isEmpty()) {
            object = map.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                eventBuilder.withTag((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!(object = context.getExtra()).isEmpty()) {
            for (Map.Entry entry : object.entrySet()) {
                eventBuilder.withExtra((String)entry.getKey(), entry.getValue());
            }
        }
    }

    private UserInterface fromUser(User user) {
        return new UserInterface(user.getId(), user.getUsername(), user.getIpAddress(), user.getEmail(), user.getData());
    }
}

