/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import shade.ru.endlesscode.rpginventory.sentry.event.Breadcrumb;
import shade.ru.endlesscode.rpginventory.sentry.event.Sdk;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.SentryInterface;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class Event
implements Serializable {
    private static final Logger _logger = LoggerFactory.getLogger(Event.class);
    private final UUID id;
    private String message;
    private Date timestamp;
    private Level level;
    private String logger;
    private String platform;
    private Sdk sdk;
    private String culprit;
    private String transaction;
    private Map<String, String> tags = new HashMap<String, String>();
    private List<Breadcrumb> breadcrumbs = new ArrayList<Breadcrumb>();
    private Map<String, Map<String, Object>> contexts = new HashMap<String, Map<String, Object>>();
    private String release;
    private String dist;
    private String environment;
    private String serverName;
    private transient Map<String, Object> extra = new HashMap<String, Object>();
    private List<String> fingerprint;
    private String checksum;
    private Map<String, SentryInterface> sentryInterfaces = new HashMap<String, SentryInterface>();

    Event(UUID uUID) {
        if (uUID == null) {
            throw new IllegalArgumentException("The id can't be null");
        }
        this.id = uUID;
    }

    public UUID getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    void setMessage(String string) {
        this.message = string;
    }

    public Date getTimestamp() {
        return this.timestamp != null ? (Date)this.timestamp.clone() : null;
    }

    void setTimestamp(Date date) {
        this.timestamp = date;
    }

    public Level getLevel() {
        return this.level;
    }

    void setLevel(Level level) {
        this.level = level;
    }

    public String getLogger() {
        return this.logger;
    }

    void setLogger(String string) {
        this.logger = string;
    }

    public String getPlatform() {
        return this.platform;
    }

    void setPlatform(String string) {
        this.platform = string;
    }

    public Sdk getSdk() {
        return this.sdk;
    }

    public void setSdk(Sdk sdk) {
        this.sdk = sdk;
    }

    public String getCulprit() {
        return this.culprit;
    }

    @Deprecated
    void setCulprit(String string) {
        this.culprit = string;
    }

    public String getTransaction() {
        return this.transaction;
    }

    void setTransaction(String string) {
        this.transaction = string;
    }

    public List<Breadcrumb> getBreadcrumbs() {
        return this.breadcrumbs;
    }

    void setBreadcrumbs(List<Breadcrumb> list) {
        this.breadcrumbs = list;
    }

    public Map<String, Map<String, Object>> getContexts() {
        return this.contexts;
    }

    public void setContexts(Map<String, Map<String, Object>> map) {
        this.contexts = map;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    void setTags(Map<String, String> map) {
        this.tags = map;
    }

    public String getServerName() {
        return this.serverName;
    }

    void setServerName(String string) {
        this.serverName = string;
    }

    public String getRelease() {
        return this.release;
    }

    void setRelease(String string) {
        this.release = string;
    }

    public String getDist() {
        return this.dist;
    }

    public void setDist(String string) {
        this.dist = string;
    }

    public String getEnvironment() {
        return this.environment;
    }

    void setEnvironment(String string) {
        this.environment = string;
    }

    public Map<String, Object> getExtra() {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
            _logger.warn("`extra` field was null, deserialization must not have been called, please check your ProGuard (or other obfuscation) configuration.");
        }
        return this.extra;
    }

    void setExtra(Map<String, Object> map) {
        this.extra = map;
    }

    public List<String> getFingerprint() {
        return this.fingerprint;
    }

    public void setFingerprint(List<String> list) {
        this.fingerprint = list;
    }

    public String getChecksum() {
        return this.checksum;
    }

    void setChecksum(String string) {
        this.checksum = string;
    }

    public Map<String, SentryInterface> getSentryInterfaces() {
        return this.sentryInterfaces;
    }

    void setSentryInterfaces(Map<String, SentryInterface> map) {
        this.sentryInterfaces = map;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.extra = (Map)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(Event.convertToSerializable(this.extra));
    }

    private static HashMap<String, ? super Serializable> convertToSerializable(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                hashMap.put(entry.getKey(), null);
                continue;
            }
            if (entry.getValue() instanceof Serializable) {
                hashMap.put(entry.getKey(), (Serializable)entry.getValue());
                continue;
            }
            hashMap.put(entry.getKey(), entry.getValue().toString());
        }
        return hashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.id.equals(((Event)object).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "Event{level=" + (Object)((Object)this.level) + ", message='" + this.message + '\'' + ", logger='" + this.logger + '\'' + '}';
    }

    public static enum Level {
        FATAL,
        ERROR,
        WARNING,
        INFO,
        DEBUG;

    }
}

