/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.event;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;

public class Breadcrumb
implements Serializable {
    private final Type type;
    private final Date timestamp;
    private final Level level;
    private final String message;
    private final String category;
    private final Map<String, String> data;

    Breadcrumb(Type type, Date date, Level level, String string, String string2, Map<String, String> map) {
        if (date == null) {
            date = new Date();
        }
        if (string == null && (map == null || map.size() < 1)) {
            throw new IllegalArgumentException("one of 'message' or 'data' must be set");
        }
        this.type = type;
        this.timestamp = date;
        this.level = level;
        this.message = string;
        this.category = string2;
        this.data = map;
    }

    public Type getType() {
        return this.type;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getCategory() {
        return this.category;
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Breadcrumb breadcrumb = (Breadcrumb)object;
        return this.type == breadcrumb.type && Objects.equals(this.timestamp, breadcrumb.timestamp) && this.level == breadcrumb.level && Objects.equals(this.message, breadcrumb.message) && Objects.equals(this.category, breadcrumb.category) && Objects.equals(this.data, breadcrumb.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.timestamp, this.level, this.message, this.category, this.data});
    }

    public static enum Type {
        DEFAULT("default"),
        HTTP("http"),
        NAVIGATION("navigation"),
        USER("user");

        private final String value;

        private Type(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum Level {
        DEBUG("debug"),
        INFO("info"),
        WARNING("warning"),
        ERROR("error"),
        CRITICAL("critical");

        private final String value;

        private Level(String string2) {
            this.value = string2;
        }

        public String getValue() {
            return this.value;
        }
    }
}

