/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.dsn;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import shade.ru.endlesscode.rpginventory.sentry.config.Lookup;
import shade.ru.endlesscode.rpginventory.sentry.dsn.InvalidDsnException;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class Dsn {
    public static final String DEFAULT_DSN = "noop://localhost?async=false";
    private static final Logger logger = LoggerFactory.getLogger(Dsn.class);
    private String secretKey;
    private String publicKey;
    private String projectId;
    private String protocol;
    private String host;
    private int port;
    private String path;
    private Set<String> protocolSettings;
    private Map<String, String> options;
    private URI uri;

    public Dsn(String string) {
        this(URI.create(string));
    }

    public Dsn(URI uRI) {
        if (uRI == null) {
            throw new InvalidDsnException("DSN constructed with null value!");
        }
        this.options = new HashMap<String, String>();
        this.protocolSettings = new HashSet<String>();
        this.extractProtocolInfo(uRI);
        this.extractUserKeys(uRI);
        this.extractHostInfo(uRI);
        this.extractPathInfo(uRI);
        this.extractOptions(uRI);
        this.makeOptionsImmutable();
        this.validate();
        try {
            this.uri = new URI(this.protocol, null, this.host, this.port, this.path, null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidDsnException("Impossible to determine Sentry's URI from the DSN '" + uRI + "'", uRISyntaxException);
        }
    }

    public static String dsnLookup() {
        String string = Lookup.lookup("dsn");
        if (Util.isNullOrEmpty(string)) {
            string = Lookup.lookup("dns");
        }
        if (Util.isNullOrEmpty(string)) {
            logger.warn("*** Couldn't find a suitable DSN, Sentry operations will do nothing! See documentation: https://docs.sentry.io/clients/java/ ***");
            string = DEFAULT_DSN;
        }
        return string;
    }

    private void extractPathInfo(URI uRI) {
        String string = uRI.getPath();
        if (string == null) {
            return;
        }
        int n = string.lastIndexOf("/") + 1;
        this.path = string.substring(0, n);
        this.projectId = string.substring(n);
    }

    private void extractHostInfo(URI uRI) {
        this.host = uRI.getHost();
        this.port = uRI.getPort();
    }

    private void extractProtocolInfo(URI uRI) {
        String string = uRI.getScheme();
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("\\+");
        this.protocolSettings.addAll(Arrays.asList(stringArray).subList(0, stringArray.length - 1));
        this.protocol = stringArray[stringArray.length - 1];
    }

    private void extractUserKeys(URI uRI) {
        String string = uRI.getUserInfo();
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(":");
        this.publicKey = stringArray[0];
        if (stringArray.length > 1) {
            this.secretKey = stringArray[1];
        }
    }

    private void extractOptions(URI uRI) {
        String string = uRI.getQuery();
        if (string == null || string.isEmpty()) {
            return;
        }
        for (String string2 : string.split("&")) {
            try {
                String[] stringArray = string2.split("=");
                String string3 = URLDecoder.decode(stringArray[0], "UTF-8");
                String string4 = stringArray.length > 1 ? URLDecoder.decode(stringArray[1], "UTF-8") : null;
                this.options.put(string3, string4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new IllegalArgumentException("Impossible to decode the query parameter '" + string2 + "'", unsupportedEncodingException);
            }
        }
    }

    private void makeOptionsImmutable() {
        this.options = Collections.unmodifiableMap(this.options);
        this.protocolSettings = Collections.unmodifiableSet(this.protocolSettings);
    }

    private void validate() {
        LinkedList<String> linkedList = new LinkedList<String>();
        if (this.host == null) {
            linkedList.add("host");
        }
        if (this.protocol != null && !this.protocol.equalsIgnoreCase("noop") && !this.protocol.equalsIgnoreCase("out")) {
            if (this.publicKey == null) {
                linkedList.add("public key");
            }
            if (this.projectId == null || this.projectId.isEmpty()) {
                linkedList.add("project ID");
            }
        }
        if (!linkedList.isEmpty()) {
            throw new InvalidDsnException("Invalid DSN, the following properties aren't set '" + linkedList + "'");
        }
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public Set<String> getProtocolSettings() {
        return this.protocolSettings;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Dsn dsn = (Dsn)object;
        if (this.port != dsn.port) {
            return false;
        }
        if (!this.host.equals(dsn.host)) {
            return false;
        }
        if (!this.options.equals(dsn.options)) {
            return false;
        }
        if (!this.path.equals(dsn.path)) {
            return false;
        }
        if (!this.projectId.equals(dsn.projectId)) {
            return false;
        }
        if (this.protocol != null ? !this.protocol.equals(dsn.protocol) : dsn.protocol != null) {
            return false;
        }
        if (!this.protocolSettings.equals(dsn.protocolSettings)) {
            return false;
        }
        if (!this.publicKey.equals(dsn.publicKey)) {
            return false;
        }
        return this.secretKey.equals(dsn.secretKey);
    }

    public int hashCode() {
        int n = this.publicKey.hashCode();
        n = 31 * n + this.projectId.hashCode();
        n = 31 * n + this.host.hashCode();
        n = 31 * n + this.port;
        n = 31 * n + this.path.hashCode();
        return n;
    }

    public String toString() {
        return "Dsn{uri=" + this.uri + '}';
    }
}

