/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.context;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import shade.ru.endlesscode.rpginventory.sentry.event.Breadcrumb;
import shade.ru.endlesscode.rpginventory.sentry.event.User;
import shade.ru.endlesscode.rpginventory.sentry.util.CircularFifoQueue;

public class Context
implements Serializable {
    private static final int DEFAULT_BREADCRUMB_LIMIT = 100;
    private final int breadcrumbLimit;
    private volatile UUID lastEventId;
    private volatile CircularFifoQueue<Breadcrumb> breadcrumbs;
    private volatile User user;
    private volatile Map<String, String> tags;
    private volatile Map<String, Object> extra;

    public Context() {
        this(100);
    }

    public Context(int n) {
        this.breadcrumbLimit = n;
    }

    public synchronized void clear() {
        this.setLastEventId(null);
        this.clearBreadcrumbs();
        this.clearUser();
        this.clearTags();
        this.clearExtra();
    }

    public synchronized List<Breadcrumb> getBreadcrumbs() {
        if (this.breadcrumbs == null || this.breadcrumbs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Breadcrumb> arrayList = new ArrayList<Breadcrumb>(this.breadcrumbs.size());
        arrayList.addAll(this.breadcrumbs);
        return arrayList;
    }

    public synchronized Map<String, String> getTags() {
        if (this.tags == null || this.tags.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.tags);
    }

    public synchronized Map<String, Object> getExtra() {
        if (this.extra == null || this.extra.isEmpty()) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.extra);
    }

    public synchronized void addTag(String string, String string2) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(string, string2);
    }

    public synchronized void removeTag(String string) {
        if (this.tags == null) {
            return;
        }
        this.tags.remove(string);
    }

    public synchronized void clearTags() {
        this.tags = null;
    }

    public synchronized void addExtra(String string, Object object) {
        if (this.extra == null) {
            this.extra = new HashMap<String, Object>();
        }
        this.extra.put(string, object);
    }

    public synchronized void removeExtra(String string) {
        if (this.extra == null) {
            return;
        }
        this.extra.remove(string);
    }

    public synchronized void clearExtra() {
        this.extra = null;
    }

    public synchronized void recordBreadcrumb(Breadcrumb breadcrumb) {
        if (this.breadcrumbs == null) {
            this.breadcrumbs = new CircularFifoQueue(this.breadcrumbLimit);
        }
        this.breadcrumbs.add(breadcrumb);
    }

    public synchronized void clearBreadcrumbs() {
        this.breadcrumbs = null;
    }

    public void setLastEventId(UUID uUID) {
        this.lastEventId = uUID;
    }

    public UUID getLastEventId() {
        return this.lastEventId;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void clearUser() {
        this.setUser(null);
    }

    public User getUser() {
        return this.user;
    }
}

