/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import shade.ru.endlesscode.rpginventory.sentry.connection.AbstractConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.ConnectionException;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.Marshaller;

public class OutputStreamConnection
extends AbstractConnection {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final OutputStream outputStream;
    private Marshaller marshaller;

    public OutputStreamConnection(OutputStream outputStream) {
        super(null, null);
        this.outputStream = outputStream;
    }

    @Override
    protected synchronized void doSend(Event event2) {
        try {
            this.outputStream.write("Sentry event:\n".getBytes(UTF_8));
            this.marshaller.marshall(event2, this.outputStream);
            this.outputStream.write("\n".getBytes(UTF_8));
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw new ConnectionException("Couldn't sent the event properly", iOException);
        }
    }

    @Override
    public void close() {
        this.outputStream.close();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }
}

