/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import shade.ru.endlesscode.rpginventory.sentry.connection.ConnectionException;
import shade.ru.endlesscode.rpginventory.sentry.time.Clock;
import shade.ru.endlesscode.rpginventory.sentry.time.SystemClock;

public class LockdownManager {
    public static final long DEFAULT_MAX_LOCKDOWN_TIME = TimeUnit.MINUTES.toMillis(5L);
    public static final long DEFAULT_BASE_LOCKDOWN_TIME = TimeUnit.SECONDS.toMillis(1L);
    private long maxLockdownTime = DEFAULT_MAX_LOCKDOWN_TIME;
    private long baseLockdownTime = DEFAULT_BASE_LOCKDOWN_TIME;
    private long lockdownTime = 0L;
    private Date lockdownStartTime = null;
    private final Clock clock;

    public LockdownManager() {
        this(new SystemClock());
    }

    public LockdownManager(Clock clock) {
        this.clock = clock;
    }

    public synchronized boolean isLockedDown() {
        return this.lockdownStartTime != null && this.clock.millis() - this.lockdownStartTime.getTime() < this.lockdownTime;
    }

    public synchronized void unlock() {
        this.lockdownTime = 0L;
        this.lockdownStartTime = null;
    }

    public synchronized boolean lockdown(ConnectionException connectionException) {
        if (this.isLockedDown()) {
            return false;
        }
        this.lockdownTime = connectionException != null && connectionException.getRecommendedLockdownTime() != null ? connectionException.getRecommendedLockdownTime() : (this.lockdownTime != 0L ? (this.lockdownTime *= 2L) : this.baseLockdownTime);
        this.lockdownTime = Math.min(this.maxLockdownTime, this.lockdownTime);
        this.lockdownStartTime = this.clock.date();
        return true;
    }

    public synchronized void setBaseLockdownTime(long l) {
        this.baseLockdownTime = l;
    }

    public synchronized void setMaxLockdownTime(long l) {
        this.maxLockdownTime = l;
    }
}

