/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import shade.ru.endlesscode.rpginventory.sentry.connection.AbstractConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.ConnectionException;
import shade.ru.endlesscode.rpginventory.sentry.connection.EventSampler;
import shade.ru.endlesscode.rpginventory.sentry.connection.TooManyRequestsException;
import shade.ru.endlesscode.rpginventory.sentry.environment.SentryEnvironment;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.Marshaller;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractConnection {
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Logger logger = LoggerFactory.getLogger(HttpConnection.class);
    private static final String USER_AGENT = "User-Agent";
    private static final String SENTRY_AUTH = "X-Sentry-Auth";
    private static final int DEFAULT_CONNECTION_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(1L);
    private static final int DEFAULT_READ_TIMEOUT = (int)TimeUnit.SECONDS.toMillis(5L);
    private static final HostnameVerifier NAIVE_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };
    private final URL sentryUrl;
    private final Proxy proxy;
    private EventSampler eventSampler;
    private Marshaller marshaller;
    private int connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    private int readTimeout = DEFAULT_READ_TIMEOUT;
    private boolean bypassSecurity = false;

    public HttpConnection(URL uRL, String string, String string2, Proxy proxy, EventSampler eventSampler) {
        super(string, string2);
        this.sentryUrl = uRL;
        this.proxy = proxy;
        this.eventSampler = eventSampler;
    }

    public static URL getSentryApiUrl(URI uRI, String string) {
        try {
            String string2 = uRI.toString() + "api/" + string + "/store/";
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("Couldn't build a valid URL from the Sentry API.", malformedURLException);
        }
    }

    protected HttpURLConnection getConnection() {
        try {
            HttpURLConnection httpURLConnection = this.proxy != null ? (HttpURLConnection)this.sentryUrl.openConnection(this.proxy) : (HttpURLConnection)this.sentryUrl.openConnection();
            if (this.bypassSecurity && httpURLConnection instanceof HttpsURLConnection) {
                ((HttpsURLConnection)httpURLConnection).setHostnameVerifier(NAIVE_VERIFIER);
            }
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setConnectTimeout(this.connectionTimeout);
            httpURLConnection.setReadTimeout(this.readTimeout);
            httpURLConnection.setRequestProperty(USER_AGENT, SentryEnvironment.getSentryName());
            httpURLConnection.setRequestProperty(SENTRY_AUTH, this.getAuthHeader());
            if (this.marshaller.getContentType() != null) {
                httpURLConnection.setRequestProperty("Content-Type", this.marshaller.getContentType());
            }
            if (this.marshaller.getContentEncoding() != null) {
                httpURLConnection.setRequestProperty("Content-Encoding", this.marshaller.getContentEncoding());
            }
            return httpURLConnection;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Couldn't set up a connection to the Sentry server.", iOException);
        }
    }

    @Override
    protected void doSend(Event event2) {
        if (this.eventSampler != null && !this.eventSampler.shouldSendEvent(event2)) {
            return;
        }
        HttpURLConnection httpURLConnection = this.getConnection();
        try {
            httpURLConnection.connect();
            OutputStream outputStream = httpURLConnection.getOutputStream();
            this.marshaller.marshall(event2, outputStream);
            outputStream.close();
            httpURLConnection.getInputStream().close();
        }
        catch (IOException iOException) {
            Integer n;
            Long l;
            block17: {
                l = null;
                String string = httpURLConnection.getHeaderField("Retry-After");
                if (string != null) {
                    try {
                        l = (long)(Double.parseDouble(string) * 1000.0);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                n = null;
                n = httpURLConnection.getResponseCode();
                if (n != 403) break block17;
                logger.debug("Event '" + event2.getId() + "' was rejected by the Sentry server due to a filter.");
                return;
            }
            try {
                if (n == 429) {
                    throw new TooManyRequestsException("Too many requests to Sentry: https://docs.sentry.io/learn/quotas/", (Throwable)iOException, l, n);
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            String string = null;
            InputStream inputStream = httpURLConnection.getErrorStream();
            if (inputStream != null) {
                string = this.getErrorMessageFromStream(inputStream);
            }
            if (null == string || string.isEmpty()) {
                string = "An exception occurred while submitting the event to the Sentry server.";
            }
            throw new ConnectionException(string, (Throwable)iOException, l, n);
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private String getErrorMessageFromStream(InputStream inputStream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, UTF_8));
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string;
            boolean bl = true;
            while ((string = bufferedReader.readLine()) != null) {
                if (!bl) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(string);
                bl = false;
            }
        }
        catch (Exception exception) {
            logger.error("Exception while reading the error message from the connection.", exception);
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public void setTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setConnectionTimeout(int n) {
        this.connectionTimeout = n;
    }

    public void setReadTimeout(int n) {
        this.readTimeout = n;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setBypassSecurity(boolean bl) {
        this.bypassSecurity = bl;
    }

    @Override
    public void close() {
    }
}

