/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.io.NotSerializableException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import shade.ru.endlesscode.rpginventory.sentry.buffer.Buffer;
import shade.ru.endlesscode.rpginventory.sentry.connection.Connection;
import shade.ru.endlesscode.rpginventory.sentry.connection.ConnectionException;
import shade.ru.endlesscode.rpginventory.sentry.connection.EventSendCallback;
import shade.ru.endlesscode.rpginventory.sentry.environment.SentryEnvironment;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class BufferedConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(BufferedConnection.class);
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    });
    private Connection actualConnection;
    private Buffer buffer;
    private boolean gracefulShutdown;
    private long shutdownTimeout;
    private volatile boolean closed = false;

    public BufferedConnection(Connection connection, Buffer buffer, long l, boolean bl, long l2) {
        this.actualConnection = connection;
        this.buffer = buffer;
        this.gracefulShutdown = bl;
        this.shutdownTimeout = l2;
        if (bl) {
            Runtime.getRuntime().addShutdownHook(this.shutDownHook);
        }
        Flusher flusher = new Flusher(l);
        this.executorService.scheduleWithFixedDelay(flusher, l, l, TimeUnit.MILLISECONDS);
    }

    @Override
    public void send(Event event2) {
        try {
            this.actualConnection.send(event2);
        }
        catch (ConnectionException connectionException) {
            boolean bl = connectionException.getCause() instanceof NotSerializableException;
            Integer n = connectionException.getResponseCode();
            if (bl || n != null) {
                this.buffer.discard(event2);
            }
            throw connectionException;
        }
        this.buffer.discard(event2);
    }

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.actualConnection.addEventSendCallback(eventSendCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.gracefulShutdown) {
            Util.safelyRemoveShutdownHook(this.shutDownHook);
            this.shutDownHook.enabled = false;
        }
        logger.debug("Gracefully shutting down Sentry buffer threads.");
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (this.shutdownTimeout == -1L) {
                long l = 5000L;
                while (!this.executorService.awaitTermination(l, TimeUnit.MILLISECONDS)) {
                    logger.debug("Still waiting on buffer flusher executor to terminate.");
                }
            } else if (!this.executorService.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> list = this.executorService.shutdownNow();
                logger.warn("{} tasks failed to execute before the shutdown.", (Object)list.size());
            }
            logger.debug("Shutdown finished.");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.warn("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> list = this.executorService.shutdownNow();
            logger.warn("{} tasks failed to execute before the shutdown.", (Object)list.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    public Connection wrapConnectionWithBufferWriter(final Connection connection) {
        return new Connection(){
            final Connection wrappedConnection;
            {
                this.wrappedConnection = connection;
            }

            @Override
            public void send(Event event2) {
                try {
                    BufferedConnection.this.buffer.add(event2);
                }
                catch (Exception exception) {
                    logger.error("Exception occurred while attempting to add Event to buffer: ", exception);
                }
                this.wrappedConnection.send(event2);
            }

            @Override
            public void addEventSendCallback(EventSendCallback eventSendCallback) {
                this.wrappedConnection.addEventSendCallback(eventSendCallback);
            }

            @Override
            public void close() {
                this.wrappedConnection.close();
            }
        };
    }

    private final class ShutDownHook
    extends Thread {
        private volatile boolean enabled = true;

        private ShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.enabled) {
                return;
            }
            SentryEnvironment.startManagingThread();
            try {
                BufferedConnection.this.close();
            }
            catch (Exception exception) {
                logger.error("An exception occurred while closing the connection.", exception);
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }

    private class Flusher
    implements Runnable {
        private long minAgeMillis;

        Flusher(long l) {
            this.minAgeMillis = l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.trace("Running Flusher");
            SentryEnvironment.startManagingThread();
            try {
                Iterator<Event> iterator2 = BufferedConnection.this.buffer.getEvents();
                while (iterator2.hasNext() && !BufferedConnection.this.closed) {
                    long l;
                    Event event2 = iterator2.next();
                    long l2 = System.currentTimeMillis();
                    long l3 = l2 - (l = event2.getTimestamp().getTime());
                    if (l3 < this.minAgeMillis) {
                        logger.trace("Ignoring buffered event because it only " + l3 + "ms old.");
                        return;
                    }
                    try {
                        logger.trace("Flusher attempting to send Event: " + event2.getId());
                        BufferedConnection.this.send(event2);
                        logger.trace("Flusher successfully sent Event: " + event2.getId());
                    }
                    catch (Exception exception) {
                        logger.debug("Flusher failed to send Event: " + event2.getId(), exception);
                        logger.trace("Flusher run exiting early.");
                        SentryEnvironment.stopManagingThread();
                        return;
                    }
                }
                logger.trace("Flusher run exiting, no more events to send.");
            }
            catch (Exception exception) {
                logger.error("Error running Flusher: ", exception);
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }
}

