/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import shade.ru.endlesscode.rpginventory.sentry.SentryClient;
import shade.ru.endlesscode.rpginventory.sentry.connection.Connection;
import shade.ru.endlesscode.rpginventory.sentry.connection.EventSendCallback;
import shade.ru.endlesscode.rpginventory.sentry.connection.LockedDownException;
import shade.ru.endlesscode.rpginventory.sentry.connection.TooManyRequestsException;
import shade.ru.endlesscode.rpginventory.sentry.environment.SentryEnvironment;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;
import shade.ru.endlesscode.rpginventory.slf4j.MDC;

public class AsyncConnection
implements Connection {
    private static final Logger logger = LoggerFactory.getLogger(AsyncConnection.class);
    private static final Logger lockdownLogger = LoggerFactory.getLogger(SentryClient.class.getName() + ".lockdown");
    private final long shutdownTimeout;
    private final Connection actualConnection;
    private final ExecutorService executorService;
    private final ShutDownHook shutDownHook = new ShutDownHook();
    private boolean gracefulShutdown;
    private volatile boolean closed;

    public AsyncConnection(Connection connection, ExecutorService executorService, boolean bl, long l) {
        this.actualConnection = connection;
        this.executorService = executorService == null ? Executors.newSingleThreadExecutor() : executorService;
        if (bl) {
            this.gracefulShutdown = bl;
            this.addShutdownHook();
        }
        this.shutdownTimeout = l;
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(this.shutDownHook);
    }

    @Override
    public void send(Event event2) {
        if (!this.closed) {
            this.executorService.execute(new EventSubmitter(event2, MDC.getCopyOfContextMap()));
        }
    }

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.actualConnection.addEventSendCallback(eventSendCallback);
    }

    @Override
    public void close() {
        if (this.gracefulShutdown) {
            Util.safelyRemoveShutdownHook(this.shutDownHook);
            this.shutDownHook.enabled = false;
        }
        this.doClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        logger.debug("Gracefully shutting down Sentry async threads.");
        this.closed = true;
        this.executorService.shutdown();
        try {
            if (this.shutdownTimeout == -1L) {
                long l = 5000L;
                while (!this.executorService.awaitTermination(l, TimeUnit.MILLISECONDS)) {
                    logger.debug("Still waiting on async executor to terminate.");
                }
            } else if (!this.executorService.awaitTermination(this.shutdownTimeout, TimeUnit.MILLISECONDS)) {
                logger.warn("Graceful shutdown took too much time, forcing the shutdown.");
                List<Runnable> list = this.executorService.shutdownNow();
                logger.warn("{} tasks failed to execute before shutdown.", (Object)list.size());
            }
            logger.debug("Shutdown finished.");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            logger.warn("Graceful shutdown interrupted, forcing the shutdown.");
            List<Runnable> list = this.executorService.shutdownNow();
            logger.warn("{} tasks failed to execute before shutdown.", (Object)list.size());
        }
        finally {
            this.actualConnection.close();
        }
    }

    private final class ShutDownHook
    extends Thread {
        private volatile boolean enabled = true;

        private ShutDownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.enabled) {
                return;
            }
            SentryEnvironment.startManagingThread();
            try {
                AsyncConnection.this.doClose();
            }
            catch (Exception exception) {
                logger.error("An exception occurred while closing the connection.", exception);
            }
            finally {
                SentryEnvironment.stopManagingThread();
            }
        }
    }

    private final class EventSubmitter
    implements Runnable {
        private final Event event;
        private Map<String, String> mdcContext;

        private EventSubmitter(Event event2, Map<String, String> map) {
            this.event = event2;
            this.mdcContext = map;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SentryEnvironment.startManagingThread();
            Map<String, String> map = MDC.getCopyOfContextMap();
            if (this.mdcContext == null) {
                MDC.clear();
            } else {
                MDC.setContextMap(this.mdcContext);
            }
            try {
                AsyncConnection.this.actualConnection.send(this.event);
            }
            catch (LockedDownException | TooManyRequestsException runtimeException) {
                logger.debug("Dropping an Event due to lockdown: " + this.event);
            }
            catch (Exception exception) {
                logger.error("An exception occurred while sending the event to Sentry.", exception);
            }
            finally {
                if (map == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap(map);
                }
                SentryEnvironment.stopManagingThread();
            }
        }
    }
}

