/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.connection;

import java.util.HashSet;
import java.util.Set;
import shade.ru.endlesscode.rpginventory.sentry.connection.Connection;
import shade.ru.endlesscode.rpginventory.sentry.connection.ConnectionException;
import shade.ru.endlesscode.rpginventory.sentry.connection.EventSendCallback;
import shade.ru.endlesscode.rpginventory.sentry.connection.LockdownManager;
import shade.ru.endlesscode.rpginventory.sentry.connection.LockedDownException;
import shade.ru.endlesscode.rpginventory.sentry.environment.SentryEnvironment;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public abstract class AbstractConnection
implements Connection {
    public static final String SENTRY_PROTOCOL_VERSION = "6";
    private static final Logger logger = LoggerFactory.getLogger(AbstractConnection.class);
    private static final Logger lockdownLogger = LoggerFactory.getLogger(AbstractConnection.class.getName() + ".lockdown");
    private final String authHeader;
    private Set<EventSendCallback> eventSendCallbacks;
    private LockdownManager lockdownManager = new LockdownManager();

    protected AbstractConnection(String string, String string2) {
        this.eventSendCallbacks = new HashSet<EventSendCallback>();
        this.authHeader = "Sentry sentry_version=6,sentry_client=" + SentryEnvironment.getSentryName() + "," + "sentry_key=" + string + (!Util.isNullOrEmpty(string2) ? ",sentry_secret=" + string2 : "");
    }

    protected String getAuthHeader() {
        return this.authHeader;
    }

    @Override
    public final void send(Event event2) {
        try {
            if (this.lockdownManager.isLockedDown()) {
                throw new LockedDownException();
            }
            this.doSend(event2);
            this.lockdownManager.unlock();
            for (EventSendCallback eventSendCallback : this.eventSendCallbacks) {
                try {
                    eventSendCallback.onSuccess(event2);
                }
                catch (Exception exception) {
                    logger.warn("An exception occurred while running an EventSendCallback.onSuccess: " + eventSendCallback.getClass().getName(), exception);
                }
            }
        }
        catch (ConnectionException connectionException) {
            for (EventSendCallback eventSendCallback : this.eventSendCallbacks) {
                try {
                    eventSendCallback.onFailure(event2, connectionException);
                }
                catch (Exception exception) {
                    logger.warn("An exception occurred while running an EventSendCallback.onFailure: " + eventSendCallback.getClass().getName(), exception);
                }
            }
            boolean bl = this.lockdownManager.lockdown(connectionException);
            if (bl) {
                lockdownLogger.warn("Initiated a temporary lockdown because of exception: " + connectionException.getMessage());
            }
            throw connectionException;
        }
    }

    protected abstract void doSend(Event var1);

    @Override
    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.eventSendCallbacks.add(eventSendCallback);
    }
}

