/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Properties;
import shade.ru.endlesscode.rpginventory.sentry.config.JndiLookup;
import shade.ru.endlesscode.rpginventory.sentry.dsn.Dsn;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public final class Lookup {
    private static final Logger logger = LoggerFactory.getLogger(Lookup.class);
    private static final String CONFIG_FILE_NAME = "sentry.properties";
    private static Properties configProps;
    private static boolean checkJndi;

    private Lookup() {
    }

    private static String getConfigFilePath() {
        String string = System.getProperty("sentry.properties.file");
        if (string == null) {
            string = System.getenv("SENTRY_PROPERTIES_FILE");
        }
        if (string == null) {
            string = CONFIG_FILE_NAME;
        }
        return string;
    }

    private static InputStream getInputStream(String string) {
        File file = new File(string);
        if (file.isFile() && file.canRead()) {
            return new FileInputStream(file);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return classLoader.getResourceAsStream(string);
    }

    public static String lookup(String string) {
        return Lookup.lookup(string, null);
    }

    public static String lookup(String string, Dsn dsn) {
        String string2 = null;
        if (checkJndi) {
            try {
                Class.forName("javax.naming.InitialContext", false, Dsn.class.getClassLoader());
                string2 = JndiLookup.jndiLookup(string);
                if (string2 != null) {
                    logger.debug("Found {}={} in JNDI.", (Object)string, (Object)string2);
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                logger.trace("JNDI is not available: " + throwable.getMessage());
                checkJndi = false;
            }
        }
        if (string2 == null && (string2 = System.getProperty("sentry." + string.toLowerCase())) != null) {
            logger.debug("Found {}={} in Java System Properties.", (Object)string, (Object)string2);
        }
        if (string2 == null && (string2 = System.getenv("SENTRY_" + string.replace(".", "_").toUpperCase())) != null) {
            logger.debug("Found {}={} in System Environment Variables.", (Object)string, (Object)string2);
        }
        if (string2 == null && dsn != null && (string2 = dsn.getOptions().get(string)) != null) {
            logger.debug("Found {}={} in DSN.", (Object)string, (Object)string2);
        }
        if (string2 == null && configProps != null && (string2 = configProps.getProperty(string)) != null) {
            logger.debug("Found {}={} in {}.", string, string2, CONFIG_FILE_NAME);
        }
        if (string2 != null) {
            return string2.trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        checkJndi = true;
        String string = Lookup.getConfigFilePath();
        InputStream inputStream = null;
        try {
            inputStream = Lookup.getInputStream(string);
            if (inputStream != null) {
                configProps = new Properties();
                configProps.load(inputStream);
            } else {
                logger.debug("Sentry configuration file not found in filesystem or classpath: '{}'.", (Object)string);
            }
        }
        catch (Exception exception) {
            logger.error("Error loading Sentry configuration file '{}': ", (Object)string, (Object)exception);
        }
        finally {
            Util.closeQuietly(inputStream);
        }
    }
}

