/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.config;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public final class JndiLookup {
    private static final String JNDI_PREFIX = "java:comp/env/sentry/";
    private static final Logger logger = LoggerFactory.getLogger(JndiLookup.class);

    private JndiLookup() {
    }

    public static String jndiLookup(String string) {
        String string2 = null;
        try {
            InitialContext initialContext = new InitialContext();
            string2 = (String)initialContext.lookup(JNDI_PREFIX + string);
        }
        catch (NoInitialContextException noInitialContextException) {
            logger.trace("JNDI not configured for Sentry (NoInitialContextEx)");
        }
        catch (NamingException namingException) {
            logger.trace("No /sentry/" + string + " in JNDI");
        }
        catch (RuntimeException runtimeException) {
            logger.warn("Odd RuntimeException while testing for JNDI", runtimeException);
        }
        return string2;
    }
}

