/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry.buffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Iterator;
import shade.ru.endlesscode.rpginventory.sentry.buffer.Buffer;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class DiskBuffer
implements Buffer {
    public static final String FILE_SUFFIX = ".sentry-event";
    private static final Logger logger = LoggerFactory.getLogger(DiskBuffer.class);
    private int maxEvents;
    private final File bufferDir;

    public DiskBuffer(File file, int n) {
        this.bufferDir = file;
        this.maxEvents = n;
        String string = "Could not create or write to disk buffer dir: " + file.getAbsolutePath();
        try {
            file.mkdirs();
            if (!file.isDirectory() || !file.canWrite()) {
                throw new RuntimeException(string);
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(string, exception);
        }
        logger.debug(Integer.toString(this.getNumStoredEvents()) + " stored events found in dir: " + file.getAbsolutePath());
    }

    @Override
    public void add(Event event2) {
        if (this.getNumStoredEvents() >= this.maxEvents) {
            logger.warn("Not adding Event because at least " + Integer.toString(this.maxEvents) + " events are already stored: " + event2.getId());
            return;
        }
        File file = new File(this.bufferDir.getAbsolutePath(), event2.getId().toString() + FILE_SUFFIX);
        if (file.exists()) {
            logger.trace("Not adding Event to offline storage because it already exists: " + file.getAbsolutePath());
            return;
        }
        logger.debug("Adding Event to offline storage: " + file.getAbsolutePath());
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);){
            objectOutputStream.writeObject(event2);
        }
        catch (Exception exception) {
            logger.error("Error writing Event to offline storage: " + event2.getId(), exception);
        }
        logger.debug(Integer.toString(this.getNumStoredEvents()) + " stored events are now in dir: " + this.bufferDir.getAbsolutePath());
    }

    @Override
    public void discard(Event event2) {
        File file = new File(this.bufferDir, event2.getId().toString() + FILE_SUFFIX);
        if (file.exists()) {
            logger.debug("Discarding Event from offline storage: " + file.getAbsolutePath());
            if (!file.delete()) {
                logger.warn("Failed to delete Event: " + file.getAbsolutePath());
            }
        }
    }

    private Event fileToEvent(File file) {
        Object object;
        try (FileInputStream fileInputStream = new FileInputStream(new File(file.getAbsolutePath()));
             ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);){
            object = objectInputStream.readObject();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            logger.error("Error reading Event file: " + file.getAbsolutePath(), exception);
            if (!file.delete()) {
                logger.warn("Failed to delete Event: " + file.getAbsolutePath());
            }
            return null;
        }
        try {
            return (Event)object;
        }
        catch (Exception exception) {
            logger.error("Error casting Object to Event: " + file.getAbsolutePath(), exception);
            if (!file.delete()) {
                logger.warn("Failed to delete Event: " + file.getAbsolutePath());
            }
            return null;
        }
    }

    private Event getNextEvent(Iterator<File> iterator2) {
        while (iterator2.hasNext()) {
            Event event2;
            File file = iterator2.next();
            if (!file.getAbsolutePath().endsWith(FILE_SUFFIX) || (event2 = this.fileToEvent(file)) == null) continue;
            return event2;
        }
        return null;
    }

    @Override
    public Iterator<Event> getEvents() {
        final Iterator<File> iterator2 = Arrays.asList(this.bufferDir.listFiles()).iterator();
        return new Iterator<Event>(){
            private Event next;
            {
                this.next = DiskBuffer.this.getNextEvent(iterator2);
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Event next() {
                Event event2 = this.next;
                this.next = DiskBuffer.this.getNextEvent(iterator2);
                return event2;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int getNumStoredEvents() {
        int n = 0;
        for (File file : this.bufferDir.listFiles()) {
            if (!file.getAbsolutePath().endsWith(FILE_SUFFIX)) continue;
            ++n;
        }
        return n;
    }
}

