/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry;

import shade.ru.endlesscode.rpginventory.sentry.Sentry;
import shade.ru.endlesscode.rpginventory.sentry.SentryClientFactory;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.event.EventBuilder;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.ExceptionInterface;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class SentryUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(SentryClientFactory.class);
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;
    private volatile Boolean enabled = true;

    public SentryUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.defaultExceptionHandler = uncaughtExceptionHandler;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (this.enabled.booleanValue()) {
            logger.trace("Uncaught exception received.");
            EventBuilder eventBuilder = new EventBuilder().withMessage(throwable.getMessage()).withLevel(Event.Level.FATAL).withSentryInterface(new ExceptionInterface(throwable));
            try {
                Sentry.capture(eventBuilder);
            }
            catch (Exception exception) {
                logger.error("Error sending uncaught exception to Sentry.", exception);
            }
        }
        if (this.defaultExceptionHandler != null) {
            this.defaultExceptionHandler.uncaughtException(thread, throwable);
        } else if (!(throwable instanceof ThreadDeath)) {
            System.err.print("Exception in thread \"" + thread.getName() + "\" ");
            throwable.printStackTrace(System.err);
        }
    }

    public static SentryUncaughtExceptionHandler setup() {
        logger.debug("Configuring uncaught exception handler.");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null) {
            logger.debug("default UncaughtExceptionHandler class='" + uncaughtExceptionHandler.getClass().getName() + "'");
        }
        SentryUncaughtExceptionHandler sentryUncaughtExceptionHandler = new SentryUncaughtExceptionHandler(uncaughtExceptionHandler);
        Thread.setDefaultUncaughtExceptionHandler(sentryUncaughtExceptionHandler);
        return sentryUncaughtExceptionHandler;
    }

    public void disable() {
        this.enabled = false;
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler == this) {
            Thread.setDefaultUncaughtExceptionHandler(this.defaultExceptionHandler);
        }
    }

    public Boolean isEnabled() {
        return this.enabled;
    }
}

