/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry;

import shade.ru.endlesscode.rpginventory.sentry.DefaultSentryClientFactory;
import shade.ru.endlesscode.rpginventory.sentry.SentryClient;
import shade.ru.endlesscode.rpginventory.sentry.config.Lookup;
import shade.ru.endlesscode.rpginventory.sentry.dsn.Dsn;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public abstract class SentryClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(SentryClientFactory.class);

    public static SentryClient sentryClient() {
        return SentryClientFactory.sentryClient(null, null);
    }

    public static SentryClient sentryClient(String string) {
        return SentryClientFactory.sentryClient(string, null);
    }

    public static SentryClient sentryClient(String string, SentryClientFactory sentryClientFactory) {
        Dsn dsn = SentryClientFactory.resolveDsn(string);
        if (sentryClientFactory == null) {
            String string2 = Lookup.lookup("factory", dsn);
            if (Util.isNullOrEmpty(string2)) {
                sentryClientFactory = new DefaultSentryClientFactory();
            } else {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2);
                    sentryClientFactory = (SentryClientFactory)clazz.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                    logger.error("Error creating SentryClient using factory class: '" + string2 + "'.", reflectiveOperationException);
                    return null;
                }
            }
        }
        return sentryClientFactory.createSentryClient(dsn);
    }

    private static Dsn resolveDsn(String string) {
        try {
            if (Util.isNullOrEmpty(string)) {
                string = Dsn.dsnLookup();
            }
            return new Dsn(string);
        }
        catch (Exception exception) {
            logger.error("Error creating valid DSN from: '{}'.", (Object)string, (Object)exception);
            throw exception;
        }
    }

    public abstract SentryClient createSentryClient(Dsn var1);

    public String toString() {
        return "SentryClientFactory{name='" + this.getClass().getName() + '\'' + '}';
    }
}

