/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import shade.ru.endlesscode.rpginventory.sentry.SentryUncaughtExceptionHandler;
import shade.ru.endlesscode.rpginventory.sentry.connection.Connection;
import shade.ru.endlesscode.rpginventory.sentry.connection.EventSendCallback;
import shade.ru.endlesscode.rpginventory.sentry.connection.LockedDownException;
import shade.ru.endlesscode.rpginventory.sentry.connection.TooManyRequestsException;
import shade.ru.endlesscode.rpginventory.sentry.context.Context;
import shade.ru.endlesscode.rpginventory.sentry.context.ContextManager;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.event.EventBuilder;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.EventBuilderHelper;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.ShouldSendEventCallback;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.ExceptionInterface;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class SentryClient {
    private static final Logger logger = LoggerFactory.getLogger(SentryClient.class);
    private static final Logger lockdownLogger = LoggerFactory.getLogger(SentryClient.class.getName() + ".lockdown");
    protected String release;
    protected String dist;
    protected String environment;
    protected String serverName;
    protected Map<String, String> tags = new HashMap<String, String>();
    protected Set<String> mdcTags = new HashSet<String>();
    protected Map<String, Object> extra = new HashMap<String, Object>();
    private final Set<ShouldSendEventCallback> shouldSendEventCallbacks = new HashSet<ShouldSendEventCallback>();
    private final Connection connection;
    private final List<EventBuilderHelper> builderHelpers = new CopyOnWriteArrayList<EventBuilderHelper>();
    private final ContextManager contextManager;
    private SentryUncaughtExceptionHandler uncaughtExceptionHandler;

    public SentryClient(Connection connection, ContextManager contextManager) {
        this.connection = connection;
        this.contextManager = contextManager;
    }

    public void runBuilderHelpers(EventBuilder eventBuilder) {
        for (EventBuilderHelper eventBuilderHelper : this.builderHelpers) {
            eventBuilderHelper.helpBuildingEvent(eventBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event event2) {
        for (ShouldSendEventCallback shouldSendEventCallback : this.shouldSendEventCallbacks) {
            if (shouldSendEventCallback.shouldSend(event2)) continue;
            logger.trace("Not sending Event because of ShouldSendEventCallback: {}", (Object)shouldSendEventCallback);
            return;
        }
        try {
            this.connection.send(event2);
        }
        catch (LockedDownException | TooManyRequestsException runtimeException) {
            logger.debug("Dropping an Event due to lockdown: " + event2);
        }
        catch (Exception exception) {
            logger.error("An exception occurred while sending the event to Sentry.", exception);
        }
        finally {
            this.getContext().setLastEventId(event2.getId());
        }
    }

    public void sendEvent(EventBuilder eventBuilder) {
        if (!Util.isNullOrEmpty(this.release)) {
            eventBuilder.withRelease(this.release.trim());
            if (!Util.isNullOrEmpty(this.dist)) {
                eventBuilder.withDist(this.dist.trim());
            }
        }
        if (!Util.isNullOrEmpty(this.environment)) {
            eventBuilder.withEnvironment(this.environment.trim());
        }
        if (!Util.isNullOrEmpty(this.serverName)) {
            eventBuilder.withServerName(this.serverName.trim());
        }
        for (Map.Entry<String, String> entry : this.tags.entrySet()) {
            eventBuilder.withTag(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.extra.entrySet()) {
            eventBuilder.withExtra(entry.getKey(), entry.getValue());
        }
        this.runBuilderHelpers(eventBuilder);
        Event event2 = eventBuilder.build();
        this.sendEvent(event2);
    }

    public void sendMessage(String string) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(string).withLevel(Event.Level.INFO);
        this.sendEvent(eventBuilder);
    }

    public void sendException(Throwable throwable) {
        EventBuilder eventBuilder = new EventBuilder().withMessage(throwable.getMessage()).withLevel(Event.Level.ERROR).withSentryInterface(new ExceptionInterface(throwable));
        this.sendEvent(eventBuilder);
    }

    public void removeBuilderHelper(EventBuilderHelper eventBuilderHelper) {
        logger.debug("Removing '{}' from the list of builder helpers.", (Object)eventBuilderHelper);
        this.builderHelpers.remove(eventBuilderHelper);
    }

    public void addBuilderHelper(EventBuilderHelper eventBuilderHelper) {
        logger.debug("Adding '{}' to the list of builder helpers.", (Object)eventBuilderHelper);
        this.builderHelpers.add(eventBuilderHelper);
    }

    public List<EventBuilderHelper> getBuilderHelpers() {
        return Collections.unmodifiableList(this.builderHelpers);
    }

    public void closeConnection() {
        if (this.uncaughtExceptionHandler != null) {
            this.uncaughtExceptionHandler.disable();
        }
        try {
            this.connection.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't close the Sentry connection", iOException);
        }
    }

    public void clearContext() {
        this.contextManager.clear();
    }

    public Context getContext() {
        return this.contextManager.getContext();
    }

    public String getRelease() {
        return this.release;
    }

    public String getDist() {
        return this.dist;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Map<String, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public Set<String> getMdcTags() {
        return Collections.unmodifiableSet(this.mdcTags);
    }

    public Map<String, Object> getExtra() {
        return this.extra;
    }

    public void setRelease(String string) {
        this.release = string;
    }

    public void setDist(String string) {
        this.dist = string;
    }

    public void setEnvironment(String string) {
        this.environment = string;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void addTag(String string, String string2) {
        this.tags.put(string, string2);
    }

    public void setTags(Map<String, String> map) {
        this.tags = map == null ? new HashMap<String, String>() : map;
    }

    @Deprecated
    public void setExtraTags(Set<String> set) {
        this.setMdcTags(set);
    }

    public void setMdcTags(Set<String> set) {
        this.mdcTags = set == null ? new HashSet<String>() : set;
    }

    @Deprecated
    public void addExtraTag(String string) {
        this.addMdcTag(string);
    }

    public void addMdcTag(String string) {
        this.mdcTags.add(string);
    }

    public void addExtra(String string, Object object) {
        this.extra.put(string, object);
    }

    public void setExtra(Map<String, Object> map) {
        this.extra = map == null ? new HashMap<String, Object>() : map;
    }

    public void addEventSendCallback(EventSendCallback eventSendCallback) {
        this.connection.addEventSendCallback(eventSendCallback);
    }

    public void addShouldSendEventCallback(ShouldSendEventCallback shouldSendEventCallback) {
        this.shouldSendEventCallbacks.add(shouldSendEventCallback);
    }

    protected void setupUncaughtExceptionHandler() {
        this.uncaughtExceptionHandler = SentryUncaughtExceptionHandler.setup();
    }

    public String toString() {
        return "SentryClient{release='" + this.release + '\'' + ", dist='" + this.dist + '\'' + ", environment='" + this.environment + '\'' + ", serverName='" + this.serverName + '\'' + ", tags=" + this.tags + ", mdcTags=" + this.mdcTags + ", extra=" + this.extra + ", connection=" + this.connection + ", builderHelpers=" + this.builderHelpers + ", contextManager=" + this.contextManager + ", uncaughtExceptionHandler=" + this.uncaughtExceptionHandler + '}';
    }
}

