/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry;

import java.util.concurrent.atomic.AtomicBoolean;
import shade.ru.endlesscode.rpginventory.sentry.SentryClient;
import shade.ru.endlesscode.rpginventory.sentry.SentryClientFactory;
import shade.ru.endlesscode.rpginventory.sentry.context.Context;
import shade.ru.endlesscode.rpginventory.sentry.event.Breadcrumb;
import shade.ru.endlesscode.rpginventory.sentry.event.Event;
import shade.ru.endlesscode.rpginventory.sentry.event.EventBuilder;
import shade.ru.endlesscode.rpginventory.sentry.event.User;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public final class Sentry {
    private static final Logger logger = LoggerFactory.getLogger(Sentry.class);
    private static volatile SentryClient storedClient = null;
    private static AtomicBoolean autoInitAttempted = new AtomicBoolean(false);

    private Sentry() {
    }

    public static SentryClient init() {
        return Sentry.init(null, null);
    }

    public static SentryClient init(SentryClientFactory sentryClientFactory) {
        return Sentry.init(null, sentryClientFactory);
    }

    public static SentryClient init(String string) {
        return Sentry.init(string, null);
    }

    public static SentryClient init(String string, SentryClientFactory sentryClientFactory) {
        SentryClient sentryClient = SentryClientFactory.sentryClient(string, sentryClientFactory);
        Sentry.setStoredClient(sentryClient);
        return sentryClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SentryClient getStoredClient() {
        if (storedClient != null) {
            return storedClient;
        }
        Class<Sentry> clazz = Sentry.class;
        synchronized (Sentry.class) {
            if (storedClient == null && !autoInitAttempted.get()) {
                autoInitAttempted.set(true);
                Sentry.init();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return storedClient;
        }
    }

    public static Context getContext() {
        return Sentry.getStoredClient().getContext();
    }

    public static void clearContext() {
        Sentry.getStoredClient().clearContext();
    }

    public static void setStoredClient(SentryClient sentryClient) {
        if (storedClient != null) {
            logger.warn("Overwriting statically stored SentryClient instance {} with {}.", (Object)storedClient, (Object)sentryClient);
        }
        storedClient = sentryClient;
    }

    public static void capture(Event event2) {
        Sentry.getStoredClient().sendEvent(event2);
    }

    public static void capture(Throwable throwable) {
        Sentry.getStoredClient().sendException(throwable);
    }

    public static void capture(String string) {
        Sentry.getStoredClient().sendMessage(string);
    }

    public static void capture(EventBuilder eventBuilder) {
        Sentry.getStoredClient().sendEvent(eventBuilder);
    }

    @Deprecated
    public static void record(Breadcrumb breadcrumb) {
        Sentry.getStoredClient().getContext().recordBreadcrumb(breadcrumb);
    }

    @Deprecated
    public static void setUser(User user) {
        Sentry.getStoredClient().getContext().setUser(user);
    }

    public static void close() {
        if (storedClient == null) {
            return;
        }
        storedClient.closeConnection();
        storedClient = null;
        autoInitAttempted.set(false);
    }
}

