/*
 * Decompiled with CFR 0.152.
 */
package shade.ru.endlesscode.rpginventory.sentry;

import java.io.File;
import java.io.Serializable;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import shade.ru.endlesscode.rpginventory.sentry.SentryClient;
import shade.ru.endlesscode.rpginventory.sentry.SentryClientFactory;
import shade.ru.endlesscode.rpginventory.sentry.buffer.Buffer;
import shade.ru.endlesscode.rpginventory.sentry.buffer.DiskBuffer;
import shade.ru.endlesscode.rpginventory.sentry.config.Lookup;
import shade.ru.endlesscode.rpginventory.sentry.connection.AsyncConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.BufferedConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.Connection;
import shade.ru.endlesscode.rpginventory.sentry.connection.HttpConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.NoopConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.OutputStreamConnection;
import shade.ru.endlesscode.rpginventory.sentry.connection.ProxyAuthenticator;
import shade.ru.endlesscode.rpginventory.sentry.connection.RandomEventSampler;
import shade.ru.endlesscode.rpginventory.sentry.context.ContextManager;
import shade.ru.endlesscode.rpginventory.sentry.context.ThreadLocalContextManager;
import shade.ru.endlesscode.rpginventory.sentry.dsn.Dsn;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.ContextBuilderHelper;
import shade.ru.endlesscode.rpginventory.sentry.event.helper.HttpEventBuilderHelper;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.DebugMetaInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.ExceptionInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.HttpInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.MessageInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.StackTraceInterface;
import shade.ru.endlesscode.rpginventory.sentry.event.interfaces.UserInterface;
import shade.ru.endlesscode.rpginventory.sentry.jvmti.FrameCache;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.Marshaller;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.DebugMetaInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.ExceptionInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.HttpInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.JsonMarshaller;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.MessageInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.StackTraceInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.marshaller.json.UserInterfaceBinding;
import shade.ru.endlesscode.rpginventory.sentry.util.Util;
import shade.ru.endlesscode.rpginventory.slf4j.Logger;
import shade.ru.endlesscode.rpginventory.slf4j.LoggerFactory;

public class DefaultSentryClientFactory
extends SentryClientFactory {
    public static final String NAIVE_PROTOCOL = "naive";
    public static final String COMPRESSION_OPTION = "compression";
    public static final String MAX_MESSAGE_LENGTH_OPTION = "maxmessagelength";
    public static final String TIMEOUT_OPTION = "timeout";
    public static final int TIMEOUT_DEFAULT = (int)TimeUnit.SECONDS.toMillis(1L);
    public static final String BUFFER_ENABLED_OPTION = "buffer.enabled";
    public static final boolean BUFFER_ENABLED_DEFAULT = true;
    public static final String BUFFER_DIR_OPTION = "buffer.dir";
    public static final String BUFFER_SIZE_OPTION = "buffer.size";
    public static final int BUFFER_SIZE_DEFAULT = 10;
    public static final String BUFFER_FLUSHTIME_OPTION = "buffer.flushtime";
    public static final long BUFFER_FLUSHTIME_DEFAULT = 60000L;
    public static final String BUFFER_GRACEFUL_SHUTDOWN_OPTION = "buffer.gracefulshutdown";
    public static final String BUFFER_SHUTDOWN_TIMEOUT_OPTION = "buffer.shutdowntimeout";
    public static final long BUFFER_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String ASYNC_OPTION = "async";
    public static final String ASYNC_GRACEFUL_SHUTDOWN_OPTION = "async.gracefulshutdown";
    public static final String ASYNC_THREADS_OPTION = "async.threads";
    public static final String ASYNC_PRIORITY_OPTION = "async.priority";
    public static final String ASYNC_QUEUE_SIZE_OPTION = "async.queuesize";
    public static final String ASYNC_QUEUE_OVERFLOW_OPTION = "async.queue.overflow";
    public static final String ASYNC_QUEUE_DISCARDOLD = "discardold";
    public static final String ASYNC_QUEUE_DISCARDNEW = "discardnew";
    public static final String ASYNC_QUEUE_SYNC = "sync";
    public static final String ASYNC_QUEUE_OVERFLOW_DEFAULT = "discardold";
    public static final String ASYNC_SHUTDOWN_TIMEOUT_OPTION = "async.shutdowntimeout";
    public static final long ASYNC_SHUTDOWN_TIMEOUT_DEFAULT = TimeUnit.SECONDS.toMillis(1L);
    public static final String IN_APP_FRAMES_OPTION = "stacktrace.app.packages";
    public static final String HIDE_COMMON_FRAMES_OPTION = "stacktrace.hidecommon";
    public static final String SAMPLE_RATE_OPTION = "sample.rate";
    public static final String HTTP_PROXY_HOST_OPTION = "http.proxy.host";
    public static final String HTTP_PROXY_PORT_OPTION = "http.proxy.port";
    public static final String HTTP_PROXY_USER_OPTION = "http.proxy.user";
    public static final String HTTP_PROXY_PASS_OPTION = "http.proxy.password";
    public static final int QUEUE_SIZE_DEFAULT = 50;
    public static final int HTTP_PROXY_PORT_DEFAULT = 80;
    public static final String RELEASE_OPTION = "release";
    public static final String DIST_OPTION = "dist";
    public static final String ENVIRONMENT_OPTION = "environment";
    public static final String SERVERNAME_OPTION = "servername";
    public static final String TAGS_OPTION = "tags";
    @Deprecated
    public static final String EXTRATAGS_OPTION = "extratags";
    public static final String MDCTAGS_OPTION = "mdctags";
    public static final String EXTRA_OPTION = "extra";
    public static final String UNCAUGHT_HANDLER_ENABLED_OPTION = "uncaught.handler.enabled";
    private static final Logger logger = LoggerFactory.getLogger(DefaultSentryClientFactory.class);
    private static final String FALSE = Boolean.FALSE.toString();
    private static final Map<String, RejectedExecutionHandler> REJECT_EXECUTION_HANDLERS = new HashMap<String, RejectedExecutionHandler>();

    @Override
    public SentryClient createSentryClient(Dsn dsn) {
        try {
            SentryClient sentryClient = new SentryClient(this.createConnection(dsn), this.getContextManager(dsn));
            try {
                Class.forName("javax.servlet.ServletRequestListener", false, this.getClass().getClassLoader());
                sentryClient.addBuilderHelper(new HttpEventBuilderHelper());
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.debug("The current environment doesn't provide access to servlets, or provides an unsupported version.");
            }
            sentryClient.addBuilderHelper(new ContextBuilderHelper(sentryClient));
            return this.configureSentryClient(sentryClient, dsn);
        }
        catch (Exception exception) {
            logger.error("Failed to initialize sentry, falling back to no-op client", exception);
            return new SentryClient(new NoopConnection(), new ThreadLocalContextManager());
        }
    }

    protected SentryClient configureSentryClient(SentryClient sentryClient, Dsn dsn) {
        Map<String, String> map;
        Object object;
        Map<String, String> map2;
        String string;
        String string2;
        String string3;
        String string4 = this.getRelease(dsn);
        if (string4 != null) {
            sentryClient.setRelease(string4);
        }
        if ((string3 = this.getDist(dsn)) != null) {
            sentryClient.setDist(string3);
        }
        if ((string2 = this.getEnvironment(dsn)) != null) {
            sentryClient.setEnvironment(string2);
        }
        if ((string = this.getServerName(dsn)) != null) {
            sentryClient.setServerName(string);
        }
        if (!(map2 = this.getTags(dsn)).isEmpty()) {
            object = map2.entrySet().iterator();
            while (object.hasNext()) {
                map = (Map.Entry)object.next();
                sentryClient.addTag((String)map.getKey(), (String)map.getValue());
            }
        }
        if (!(object = this.getMdcTags(dsn)).isEmpty()) {
            map = object.iterator();
            while (map.hasNext()) {
                Iterator<String> iterator2 = (String)map.next();
                sentryClient.addMdcTag((String)((Object)iterator2));
            }
        }
        if (!(map = this.getExtra(dsn)).isEmpty()) {
            for (Map.Entry object2 : map.entrySet()) {
                sentryClient.addExtra((String)object2.getKey(), object2.getValue());
            }
        }
        if (this.getUncaughtHandlerEnabled(dsn)) {
            sentryClient.setupUncaughtExceptionHandler();
        }
        for (String string5 : this.getInAppFrames(dsn)) {
            FrameCache.addAppPackage(string5);
        }
        return sentryClient;
    }

    protected Connection createConnection(Dsn dsn) {
        Buffer buffer;
        Connection connection;
        String string = dsn.getProtocol();
        if (string.equalsIgnoreCase("http") || string.equalsIgnoreCase("https")) {
            logger.debug("Using an {} connection to Sentry.", (Object)string.toUpperCase());
            connection = this.createHttpConnection(dsn);
        } else if (string.equalsIgnoreCase("out")) {
            logger.debug("Using StdOut to send events.");
            connection = this.createStdOutConnection(dsn);
        } else if (string.equalsIgnoreCase("noop")) {
            logger.debug("Using noop to send events.");
            connection = new NoopConnection();
        } else {
            throw new IllegalStateException("Couldn't create a connection for the protocol '" + string + "'");
        }
        BufferedConnection bufferedConnection = null;
        if (this.getBufferEnabled(dsn) && (buffer = this.getBuffer(dsn)) != null) {
            long l = this.getBufferFlushtime(dsn);
            boolean bl = this.getBufferedConnectionGracefulShutdownEnabled(dsn);
            Long l2 = this.getBufferedConnectionShutdownTimeout(dsn);
            bufferedConnection = new BufferedConnection(connection, buffer, l, bl, l2);
            connection = bufferedConnection;
        }
        if (this.getAsyncEnabled(dsn)) {
            connection = this.createAsyncConnection(dsn, connection);
        }
        if (bufferedConnection != null) {
            connection = bufferedConnection.wrapConnectionWithBufferWriter(connection);
        }
        return connection;
    }

    protected Connection createAsyncConnection(Dsn dsn, Connection connection) {
        int n = this.getAsyncThreads(dsn);
        int n2 = this.getAsyncPriority(dsn);
        int n3 = this.getAsyncQueueSize(dsn);
        LinkedBlockingDeque<Runnable> linkedBlockingDeque = n3 == -1 ? new LinkedBlockingDeque<Runnable>() : new LinkedBlockingDeque(n3);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n, 0L, TimeUnit.MILLISECONDS, linkedBlockingDeque, new DaemonThreadFactory(n2), this.getRejectedExecutionHandler(dsn));
        boolean bl = this.getAsyncGracefulShutdownEnabled(dsn);
        long l = this.getAsyncShutdownTimeout(dsn);
        return new AsyncConnection(connection, threadPoolExecutor, bl, l);
    }

    protected Connection createHttpConnection(Dsn dsn) {
        Serializable serializable;
        URL uRL = HttpConnection.getSentryApiUrl(dsn.getUri(), dsn.getProjectId());
        String string = this.getProxyHost(dsn);
        String string2 = this.getProxyUser(dsn);
        String string3 = this.getProxyPass(dsn);
        int n = this.getProxyPort(dsn);
        Proxy proxy = null;
        if (string != null) {
            serializable = new InetSocketAddress(string, n);
            proxy = new Proxy(Proxy.Type.HTTP, (SocketAddress)serializable);
            if (string2 != null && string3 != null) {
                Authenticator.setDefault(new ProxyAuthenticator(string2, string3));
            }
        }
        serializable = this.getSampleRate(dsn);
        RandomEventSampler randomEventSampler = null;
        if (serializable != null) {
            randomEventSampler = new RandomEventSampler((Double)serializable);
        }
        HttpConnection httpConnection = new HttpConnection(uRL, dsn.getPublicKey(), dsn.getSecretKey(), proxy, randomEventSampler);
        Marshaller marshaller = this.createMarshaller(dsn);
        httpConnection.setMarshaller(marshaller);
        int n2 = this.getTimeout(dsn);
        httpConnection.setConnectionTimeout(n2);
        boolean bl = this.getBypassSecurityEnabled(dsn);
        httpConnection.setBypassSecurity(bl);
        return httpConnection;
    }

    protected Connection createStdOutConnection(Dsn dsn) {
        OutputStreamConnection outputStreamConnection = new OutputStreamConnection(System.out);
        outputStreamConnection.setMarshaller(this.createMarshaller(dsn));
        return outputStreamConnection;
    }

    protected Marshaller createMarshaller(Dsn dsn) {
        int n = this.getMaxMessageLength(dsn);
        JsonMarshaller jsonMarshaller = this.createJsonMarshaller(n);
        StackTraceInterfaceBinding stackTraceInterfaceBinding = new StackTraceInterfaceBinding();
        stackTraceInterfaceBinding.setRemoveCommonFramesWithEnclosing(this.getHideCommonFramesEnabled(dsn));
        stackTraceInterfaceBinding.setInAppFrames(this.getInAppFrames(dsn));
        jsonMarshaller.addInterfaceBinding(StackTraceInterface.class, stackTraceInterfaceBinding);
        jsonMarshaller.addInterfaceBinding(ExceptionInterface.class, new ExceptionInterfaceBinding(stackTraceInterfaceBinding));
        jsonMarshaller.addInterfaceBinding(MessageInterface.class, new MessageInterfaceBinding(n));
        jsonMarshaller.addInterfaceBinding(UserInterface.class, new UserInterfaceBinding());
        jsonMarshaller.addInterfaceBinding(DebugMetaInterface.class, new DebugMetaInterfaceBinding());
        HttpInterfaceBinding httpInterfaceBinding = new HttpInterfaceBinding();
        jsonMarshaller.addInterfaceBinding(HttpInterface.class, httpInterfaceBinding);
        jsonMarshaller.setCompression(this.getCompressionEnabled(dsn));
        return jsonMarshaller;
    }

    protected JsonMarshaller createJsonMarshaller(int n) {
        return new JsonMarshaller(n);
    }

    protected ContextManager getContextManager(Dsn dsn) {
        return new ThreadLocalContextManager();
    }

    protected Collection<String> getInAppFrames(Dsn dsn) {
        String string = Lookup.lookup(IN_APP_FRAMES_OPTION, dsn);
        if (Util.isNullOrEmpty(string)) {
            if (string == null) {
                logger.warn("No 'stacktrace.app.packages' was configured, this option is highly recommended as it affects stacktrace grouping and display on Sentry. See documentation: https://docs.sentry.io/clients/java/config/#in-application-stack-frames");
            }
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            if (string2.trim().equals("")) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }

    protected boolean getAsyncEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(ASYNC_OPTION, dsn));
    }

    protected RejectedExecutionHandler getRejectedExecutionHandler(Dsn dsn) {
        RejectedExecutionHandler rejectedExecutionHandler;
        String string = "discardold";
        String string2 = Lookup.lookup(ASYNC_QUEUE_OVERFLOW_OPTION, dsn);
        if (!Util.isNullOrEmpty(string2)) {
            string = string2.toLowerCase();
        }
        if ((rejectedExecutionHandler = REJECT_EXECUTION_HANDLERS.get(string)) == null) {
            String string3 = Arrays.toString(REJECT_EXECUTION_HANDLERS.keySet().toArray());
            throw new RuntimeException("RejectedExecutionHandler not found: '" + string + "', valid choices are: " + string3);
        }
        return rejectedExecutionHandler;
    }

    protected long getBufferedConnectionShutdownTimeout(Dsn dsn) {
        return Util.parseLong(Lookup.lookup(BUFFER_SHUTDOWN_TIMEOUT_OPTION, dsn), BUFFER_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getBufferedConnectionGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(BUFFER_GRACEFUL_SHUTDOWN_OPTION, dsn));
    }

    protected long getBufferFlushtime(Dsn dsn) {
        return Util.parseLong(Lookup.lookup(BUFFER_FLUSHTIME_OPTION, dsn), 60000L);
    }

    protected long getAsyncShutdownTimeout(Dsn dsn) {
        return Util.parseLong(Lookup.lookup(ASYNC_SHUTDOWN_TIMEOUT_OPTION, dsn), ASYNC_SHUTDOWN_TIMEOUT_DEFAULT);
    }

    protected boolean getAsyncGracefulShutdownEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(ASYNC_GRACEFUL_SHUTDOWN_OPTION, dsn));
    }

    protected int getAsyncQueueSize(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(ASYNC_QUEUE_SIZE_OPTION, dsn), 50);
    }

    protected int getAsyncPriority(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(ASYNC_PRIORITY_OPTION, dsn), 1);
    }

    protected int getAsyncThreads(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(ASYNC_THREADS_OPTION, dsn), Runtime.getRuntime().availableProcessors());
    }

    protected boolean getBypassSecurityEnabled(Dsn dsn) {
        return dsn.getProtocolSettings().contains(NAIVE_PROTOCOL);
    }

    protected Double getSampleRate(Dsn dsn) {
        return Util.parseDouble(Lookup.lookup(SAMPLE_RATE_OPTION, dsn), null);
    }

    protected int getProxyPort(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(HTTP_PROXY_PORT_OPTION, dsn), 80);
    }

    protected String getProxyHost(Dsn dsn) {
        return Lookup.lookup(HTTP_PROXY_HOST_OPTION, dsn);
    }

    protected String getProxyUser(Dsn dsn) {
        return Lookup.lookup(HTTP_PROXY_USER_OPTION, dsn);
    }

    protected String getProxyPass(Dsn dsn) {
        return Lookup.lookup(HTTP_PROXY_PASS_OPTION, dsn);
    }

    protected String getRelease(Dsn dsn) {
        return Lookup.lookup(RELEASE_OPTION, dsn);
    }

    protected String getDist(Dsn dsn) {
        return Lookup.lookup(DIST_OPTION, dsn);
    }

    protected String getEnvironment(Dsn dsn) {
        return Lookup.lookup(ENVIRONMENT_OPTION, dsn);
    }

    protected String getServerName(Dsn dsn) {
        return Lookup.lookup(SERVERNAME_OPTION, dsn);
    }

    protected Map<String, String> getTags(Dsn dsn) {
        return Util.parseTags(Lookup.lookup(TAGS_OPTION, dsn));
    }

    @Deprecated
    protected Set<String> getExtraTags(Dsn dsn) {
        return this.getMdcTags(dsn);
    }

    protected Set<String> getMdcTags(Dsn dsn) {
        String string = Lookup.lookup(MDCTAGS_OPTION, dsn);
        if (Util.isNullOrEmpty(string) && !Util.isNullOrEmpty(string = Lookup.lookup(EXTRATAGS_OPTION, dsn))) {
            logger.warn("The 'extratags' option is deprecated, please use the 'mdctags' option instead.");
        }
        return Util.parseMdcTags(string);
    }

    protected Map<String, String> getExtra(Dsn dsn) {
        return Util.parseExtra(Lookup.lookup(EXTRA_OPTION, dsn));
    }

    protected boolean getCompressionEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(COMPRESSION_OPTION, dsn));
    }

    protected boolean getHideCommonFramesEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(HIDE_COMMON_FRAMES_OPTION, dsn));
    }

    protected int getMaxMessageLength(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(MAX_MESSAGE_LENGTH_OPTION, dsn), 1000);
    }

    protected int getTimeout(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(TIMEOUT_OPTION, dsn), TIMEOUT_DEFAULT);
    }

    protected boolean getBufferEnabled(Dsn dsn) {
        String string = Lookup.lookup(BUFFER_ENABLED_OPTION, dsn);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return true;
    }

    protected Buffer getBuffer(Dsn dsn) {
        String string = Lookup.lookup(BUFFER_DIR_OPTION, dsn);
        if (string != null) {
            return new DiskBuffer(new File(string), this.getBufferSize(dsn));
        }
        return null;
    }

    protected int getBufferSize(Dsn dsn) {
        return Util.parseInteger(Lookup.lookup(BUFFER_SIZE_OPTION, dsn), 10);
    }

    protected boolean getUncaughtHandlerEnabled(Dsn dsn) {
        return !FALSE.equalsIgnoreCase(Lookup.lookup(UNCAUGHT_HANDLER_ENABLED_OPTION, dsn));
    }

    static {
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_SYNC, new ThreadPoolExecutor.CallerRunsPolicy());
        REJECT_EXECUTION_HANDLERS.put(ASYNC_QUEUE_DISCARDNEW, new ThreadPoolExecutor.DiscardPolicy());
        REJECT_EXECUTION_HANDLERS.put("discardold", new ThreadPoolExecutor.DiscardOldestPolicy());
    }

    protected static final class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;
        private final int priority;

        private DaemonThreadFactory(int n) {
            SecurityManager securityManager = System.getSecurityManager();
            this.group = securityManager != null ? securityManager.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "sentry-pool-" + POOL_NUMBER.getAndIncrement() + "-thread-";
            this.priority = n;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            if (thread.getPriority() != this.priority) {
                thread.setPriority(this.priority);
            }
            return thread;
        }
    }
}

